/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.aggregate;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.seasar.doma.internal.util.Combinations;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.EntityId;
import org.seasar.doma.jdbc.EntityRef;
import org.seasar.doma.jdbc.aggregate.AggregateStrategyType;
import org.seasar.doma.jdbc.aggregate.AssociationEntityKey;
import org.seasar.doma.jdbc.aggregate.AssociationEntityPool;
import org.seasar.doma.jdbc.aggregate.AssociationEntityPoolEntry;
import org.seasar.doma.jdbc.aggregate.AssociationEntityPoolIterationHandler;
import org.seasar.doma.jdbc.aggregate.AssociationLinkerType;
import org.seasar.doma.jdbc.aggregate.StreamReducer;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.SelectQuery;

public class AggregateCommand<RESULT, ENTITY>
implements Command<RESULT> {
    private final SelectQuery query;
    private final EntityType<ENTITY> rootEntityType;
    private final StreamReducer<RESULT, ENTITY> streamReducer;
    private final AggregateStrategyType aggregateStrategyType;

    public AggregateCommand(SelectQuery query, EntityType<ENTITY> rootEntityType, StreamReducer<RESULT, ENTITY> streamReducer, AggregateStrategyType aggregateStrategyType) {
        this.query = Objects.requireNonNull(query);
        this.rootEntityType = Objects.requireNonNull(rootEntityType);
        this.streamReducer = Objects.requireNonNull(streamReducer);
        this.aggregateStrategyType = Objects.requireNonNull(aggregateStrategyType);
    }

    @Override
    public RESULT execute() {
        LinkedHashSet<EntityId> rootEntityIds = new LinkedHashSet<EntityId>();
        HashMap<EntityId, EntityRef> entityCache = new HashMap<EntityId, EntityRef>();
        Combinations<AssociationEntityKey> combinations = new Combinations<AssociationEntityKey>();
        SelectCommand<List<AssociationEntityPool>> command = new SelectCommand<List<AssociationEntityPool>>(this.query, new AssociationEntityPoolIterationHandler(this.rootEntityType, this.aggregateStrategyType, this.query.isResultMappingEnsured(), rootEntityIds, entityCache));
        List<AssociationEntityPool> entityPools = command.execute();
        for (AssociationEntityPool entityPool : entityPools) {
            this.associate(combinations, entityPool);
        }
        Stream<Object> stream = rootEntityIds.stream().map(entityCache::get).map(EntityRef::getEntity).filter(Objects::nonNull).filter(this.rootEntityType.getEntityClass()::isInstance);
        return this.streamReducer.reduce(stream);
    }

    private void associate(Combinations<AssociationEntityKey> combinations, AssociationEntityPool entityPool) {
        for (AssociationLinkerType<?, ?> linkerType : this.aggregateStrategyType.getAssociationLinkerTypes()) {
            Object targetEntity;
            Pair<AssociationEntityKey, AssociationEntityKey> keyPair;
            AssociationEntityPoolEntry source = entityPool.get(linkerType.getSourcePathKey());
            AssociationEntityPoolEntry target = entityPool.get(linkerType.getTargetPathKey());
            if (source == null || target == null || combinations.contains(keyPair = new Pair<AssociationEntityKey, AssociationEntityKey>(source.entityKey(), target.entityKey()))) continue;
            combinations.add(keyPair);
            BiFunction<?, ?, ?> linker = linkerType.getLinker();
            EntityRef sourceEntityRef = source.entityRef();
            EntityRef targetEntityRef = target.entityRef();
            Object sourceEntity = sourceEntityRef.getEntity();
            Object resultEntity = linker.apply(sourceEntity, targetEntity = targetEntityRef.getEntity());
            if (resultEntity == null || resultEntity == sourceEntity) continue;
            sourceEntityRef.setEntity(resultEntity);
        }
    }

    @Override
    public Query getQuery() {
        return this.query;
    }
}

