/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.aggregate;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.seasar.doma.internal.jdbc.command.AbstractIterationHandler;
import org.seasar.doma.internal.jdbc.command.ResultListCallback;
import org.seasar.doma.jdbc.EntityId;
import org.seasar.doma.jdbc.EntityRef;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.aggregate.AggregateStrategyType;
import org.seasar.doma.jdbc.aggregate.AssociationEntityPool;
import org.seasar.doma.jdbc.aggregate.AssociationEntityPoolProvider;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.SelectQuery;

public class AssociationEntityPoolIterationHandler
extends AbstractIterationHandler<AssociationEntityPool, List<AssociationEntityPool>> {
    private final EntityType<?> rootEntityType;
    private final AggregateStrategyType aggregateStrategyType;
    private final boolean resultMappingEnsured;
    private final Set<EntityId> rootEntityIds;
    private final Map<EntityId, EntityRef> entityCache;

    public AssociationEntityPoolIterationHandler(EntityType<?> rootEntityType, AggregateStrategyType aggregateStrategyType, boolean resultMappingEnsured, Set<EntityId> rootEntityIds, Map<EntityId, EntityRef> entityCache) {
        super(new ResultListCallback());
        this.rootEntityType = Objects.requireNonNull(rootEntityType);
        this.aggregateStrategyType = Objects.requireNonNull(aggregateStrategyType);
        this.resultMappingEnsured = resultMappingEnsured;
        this.rootEntityIds = Objects.requireNonNull(rootEntityIds);
        this.entityCache = Objects.requireNonNull(entityCache);
    }

    @Override
    protected ObjectProvider<AssociationEntityPool> createObjectProvider(SelectQuery query) {
        return new AssociationEntityPoolProvider(this.rootEntityType, this.aggregateStrategyType, query, this.resultMappingEnsured, this.rootEntityIds, this.entityCache);
    }
}

