/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.aggregate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.seasar.doma.internal.jdbc.command.AbstractObjectProvider;
import org.seasar.doma.internal.jdbc.command.FetchSupport;
import org.seasar.doma.internal.jdbc.command.MappingSupport;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.EntityId;
import org.seasar.doma.jdbc.EntityRef;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.aggregate.AggregateStrategyType;
import org.seasar.doma.jdbc.aggregate.AssociationEntityKey;
import org.seasar.doma.jdbc.aggregate.AssociationEntityPool;
import org.seasar.doma.jdbc.aggregate.AssociationEntityPoolEntry;
import org.seasar.doma.jdbc.aggregate.AssociationLinkerType;
import org.seasar.doma.jdbc.aggregate.AssociationPathKey;
import org.seasar.doma.jdbc.entity.AssociationPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.Query;

public class AssociationEntityPoolProvider
extends AbstractObjectProvider<AssociationEntityPool> {
    private final EntityType<?> rootEntityType;
    private final Query query;
    private final Set<EntityId> rootEntityIds;
    private final Map<EntityId, EntityRef> entityCache;
    private Map<Integer, MappingSupport.PropType> indexMap;
    private final MappingSupport mappingSupport;
    private final FetchSupport fetchSupport;
    private final AggregateStrategyType aggregateStrategyType;
    private final Map<String, AssociationLinkerType<?, ?>> associationLinkerTypeMap;

    public AssociationEntityPoolProvider(EntityType<?> rootEntityType, AggregateStrategyType aggregateStrategyType, Query query, boolean resultMappingEnsured, Set<EntityId> rootEntityIds, Map<EntityId, EntityRef> entityCache) {
        AssertionUtil.assertNotNull(rootEntityType, (Object)aggregateStrategyType, (Object)query, rootEntityIds, entityCache);
        this.rootEntityType = rootEntityType;
        this.query = query;
        this.rootEntityIds = rootEntityIds;
        this.entityCache = entityCache;
        this.mappingSupport = new MappingSupport(rootEntityType, query, resultMappingEnsured, query.getConfig().getUnknownColumnHandler(), query.getConfig().getDuplicateColumnHandler());
        this.fetchSupport = new FetchSupport(query);
        this.aggregateStrategyType = aggregateStrategyType;
        this.associationLinkerTypeMap = aggregateStrategyType.getAssociationLinkerTypes().stream().collect(Collectors.toMap(AssociationLinkerType::getPropertyPath, Function.identity()));
    }

    @Override
    public AssociationEntityPool get(ResultSet resultSet) throws SQLException {
        List<MappingSupport.Prop> props = this.createProps(resultSet);
        Map<AssociationPathKey, List<MappingSupport.Prop>> propGroup = this.groupPropsByPathKey(props);
        return this.createEntityPool(propGroup);
    }

    private List<MappingSupport.Prop> createProps(ResultSet resultSet) throws SQLException {
        AssertionUtil.assertNotNull(resultSet);
        if (this.indexMap == null) {
            Map<String, MappingSupport.PropType> columnNameMap = this.createColumnNameMap();
            this.indexMap = this.mappingSupport.createIndexMap(resultSet.getMetaData(), columnNameMap);
        }
        ArrayList<MappingSupport.Prop> props = new ArrayList<MappingSupport.Prop>(this.indexMap.size());
        for (Map.Entry<Integer, MappingSupport.PropType> entry : this.indexMap.entrySet()) {
            Integer index = entry.getKey();
            MappingSupport.PropType propType = entry.getValue();
            EntityPropertyType<?, ?> propertyType = propType.propertyType();
            Property<?, ?> property = propertyType.createProperty();
            Object rawValue = this.fetchSupport.fetch(resultSet, property, index);
            props.add(new MappingSupport.Prop(propType, property, rawValue));
        }
        return props;
    }

    private Map<String, MappingSupport.PropType> createColumnNameMap() {
        List<EntityPropertyType<?, ?>> propertyTypes = this.rootEntityType.getEntityPropertyTypes();
        HashMap<String, MappingSupport.PropType> result = new HashMap<String, MappingSupport.PropType>(propertyTypes.size());
        this.collectColumnNames(result, this.rootEntityType, "", this.aggregateStrategyType.getTableAlias());
        return result;
    }

    private void collectColumnNames(Map<String, MappingSupport.PropType> map, EntityType<?> source, String propertyPath, String tableAlias) {
        Naming naming = this.query.getConfig().getNaming();
        String prefix = tableAlias + "_";
        for (EntityPropertyType<?, ?> propertyType : source.getEntityPropertyTypes()) {
            String columnName = propertyType.getColumnName(naming::apply);
            map.put(prefix + columnName.toLowerCase(), new MappingSupport.PropType(source, propertyType, propertyPath));
        }
        Object propertyPrefix = propertyPath.isEmpty() ? "" : propertyPath + ".";
        for (AssociationPropertyType associationPropertyType : source.getAssociationPropertyTypes()) {
            String path = (String)propertyPrefix + associationPropertyType.getName();
            AssociationLinkerType<?, ?> associationLinkerType = this.associationLinkerTypeMap.get(path);
            if (associationLinkerType == null || associationLinkerType.getSource() != source) continue;
            this.collectColumnNames(map, associationLinkerType.getTarget(), associationLinkerType.getPropertyPath(), associationLinkerType.getTableAlias());
        }
    }

    private Map<AssociationPathKey, List<MappingSupport.Prop>> groupPropsByPathKey(List<MappingSupport.Prop> props) {
        return props.stream().collect(Collectors.groupingBy(it -> new AssociationPathKey(it.propertyPath(), it.entityType())));
    }

    private AssociationEntityPool createEntityPool(Map<AssociationPathKey, List<MappingSupport.Prop>> propGroup) {
        AssociationEntityPool entityPool = new AssociationEntityPool();
        for (Map.Entry<AssociationPathKey, List<MappingSupport.Prop>> entry : propGroup.entrySet()) {
            AssociationPathKey pathKey = entry.getKey();
            List<MappingSupport.Prop> props = entry.getValue();
            if (props.stream().allMatch(p -> p.rawValue() == null)) continue;
            AssociationEntityKey entityKey = AssociationEntityPoolProvider.createEntityKey(pathKey, props);
            EntityId entityId = entityKey.entityId();
            EntityRef entityRef = this.entityCache.computeIfAbsent(entityId, id -> AssociationEntityPoolProvider.createEntityRef(id, props));
            entityPool.add(new AssociationEntityPoolEntry(entityKey, entityRef));
            if (!pathKey.isRoot()) continue;
            this.rootEntityIds.add(entityId);
        }
        return entityPool;
    }

    private static AssociationEntityKey createEntityKey(AssociationPathKey pathKey, List<MappingSupport.Prop> props) {
        AssociationEntityKey entityKey;
        if (pathKey.entityType().getIdPropertyTypes().isEmpty()) {
            entityKey = new AssociationEntityKey(pathKey, Collections.singletonList(new Object()));
        } else {
            List<Object> items = props.stream().filter(MappingSupport.Prop::isId).map(it -> it.wrapper().get()).toList();
            entityKey = new AssociationEntityKey(pathKey, items);
        }
        return entityKey;
    }

    private static EntityRef createEntityRef(EntityId entityId, List<MappingSupport.Prop> props) {
        EntityType<?> entityType = entityId.entityType();
        Map states = props.stream().collect(Collectors.toMap(MappingSupport.Prop::name, MappingSupport.Prop::property));
        Object entity = entityType.newEntity(states);
        if (!entityType.isImmutable()) {
            entityType.saveCurrentStates(entity);
        }
        return new EntityRef(entity);
    }
}

