/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.aggregate;

import java.util.Objects;
import java.util.function.BiFunction;
import org.seasar.doma.jdbc.aggregate.AssociationPathKey;
import org.seasar.doma.jdbc.entity.EntityType;

public class AssociationLinkerType<S, T> {
    private final String propertyPath;
    private final String tableAlias;
    private final EntityType<S> source;
    private final String ancestorPath;
    private final EntityType<T> target;
    private final int propertyPathDepth;
    private final BiFunction<S, T, S> linker;

    private AssociationLinkerType(String ancestorPath, String propertyPath, int propertyPathDepth, String tableAlias, EntityType<S> source, EntityType<T> target, BiFunction<S, T, S> linker) {
        this.ancestorPath = ancestorPath;
        this.propertyPath = propertyPath;
        this.propertyPathDepth = propertyPathDepth;
        this.tableAlias = tableAlias;
        this.source = source;
        this.target = target;
        this.linker = linker;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public EntityType<S> getSource() {
        return this.source;
    }

    public String getAncestorPath() {
        return this.ancestorPath;
    }

    public EntityType<T> getTarget() {
        return this.target;
    }

    public int getPropertyPathDepth() {
        return this.propertyPathDepth;
    }

    public BiFunction<S, T, S> getLinker() {
        return this.linker;
    }

    public AssociationPathKey getSourcePathKey() {
        return new AssociationPathKey(this.ancestorPath, this.source);
    }

    public AssociationPathKey getTargetPathKey() {
        return new AssociationPathKey(this.propertyPath, this.target);
    }

    public static <S, T> AssociationLinkerType<S, T> of(String ancestorPath, String propertyPath, int propertyPathDepth, String tableAlias, EntityType<S> source, EntityType<T> target, BiFunction<S, T, S> linker) {
        Objects.requireNonNull(ancestorPath);
        Objects.requireNonNull(propertyPath);
        Objects.requireNonNull(tableAlias);
        Objects.requireNonNull(source);
        Objects.requireNonNull(target);
        Objects.requireNonNull(linker);
        return new AssociationLinkerType<S, T>(ancestorPath, propertyPath, propertyPathDepth, tableAlias, source, target, linker);
    }
}

