/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.builder.BatchParam;

class BatchBuildingHelper {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final LinkedList<Item> items = new LinkedList();
    private final Map<String, Integer> paramIndexMap = new HashMap<String, Integer>();

    BatchBuildingHelper() {
    }

    void appendSql(String sql) {
        this.items.add(Item.sql(sql));
    }

    void appendSqlWithLineSeparator(String sql) {
        if (this.items.isEmpty()) {
            this.items.add(Item.sql(sql));
        } else {
            this.items.add(Item.sql(lineSeparator + sql));
        }
    }

    void appendParam(BatchParam<?> param) {
        this.paramIndexMap.put(param.name, this.items.size());
        this.items.add(Item.param(param));
    }

    void modifyParam(BatchParam<?> param) {
        int index = this.paramIndexMap.get(param.name);
        this.items.set(index, Item.param(param));
    }

    void removeLast() {
        if (!this.items.isEmpty()) {
            this.items.removeLast();
        }
    }

    BatchParam<?> getParam(String paramName) {
        return this.items.get((int)this.paramIndexMap.get((Object)paramName).intValue()).param;
    }

    Iterable<BatchParam<?>> getParams() {
        ArrayList results = new ArrayList();
        for (Item item : this.items) {
            if (item.kind != ItemKind.PARAM) continue;
            results.add(item.param);
        }
        return results;
    }

    SqlNode getSqlNode() {
        StringBuilder buf = new StringBuilder(200);
        block4: for (Item item : this.items) {
            switch (item.kind) {
                case SQL: {
                    buf.append(item.sql);
                    continue block4;
                }
                case PARAM: {
                    buf.append("/*");
                    if (item.param.literal) {
                        buf.append("^");
                    }
                    buf.append(item.param.name);
                    buf.append("*/0");
                    continue block4;
                }
            }
            AssertionUtil.assertUnreachable();
        }
        SqlParser parser = new SqlParser(buf.toString());
        return parser.parse();
    }

    private static class Item {
        private ItemKind kind;
        private String sql;
        private BatchParam<?> param;

        private Item() {
        }

        public static Item sql(String sql) {
            Item item = new Item();
            item.kind = ItemKind.SQL;
            item.sql = sql;
            return item;
        }

        public static Item param(BatchParam<?> param) {
            Item item = new Item();
            item.kind = ItemKind.PARAM;
            item.param = param;
            return item;
        }
    }

    private static enum ItemKind {
        SQL,
        PARAM;

    }
}

