/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.List;
import java.util.function.BiConsumer;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.builder.BatchBuilder;
import org.seasar.doma.jdbc.command.BatchDeleteCommand;
import org.seasar.doma.jdbc.query.SqlBatchDeleteQuery;

public class BatchDeleteExecutor {
    private final SqlBatchDeleteQuery query = new SqlBatchDeleteQuery();

    private BatchDeleteExecutor(Config config) {
        this.query.setConfig(config);
        this.query.setCallerClassName(this.getClass().getName());
        this.query.setSqlLogType(SqlLogType.FORMATTED);
    }

    public static BatchDeleteExecutor newInstance(Config config) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        return new BatchDeleteExecutor(config);
    }

    public void queryTimeout(int queryTimeout) {
        this.query.setQueryTimeout(queryTimeout);
    }

    public void sqlLogType(SqlLogType sqlLogType) {
        if (sqlLogType == null) {
            throw new DomaNullPointerException("sqlLogType");
        }
        this.query.setSqlLogType(sqlLogType);
    }

    public void batchSize(int batchSize) {
        this.query.setBatchSize(batchSize);
    }

    public void callerClassName(String className) {
        if (className == null) {
            throw new DomaNullPointerException("className");
        }
        this.query.setCallerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.query.setCallerMethodName(methodName);
    }

    public <P> int[] execute(Iterable<P> params, BiConsumer<P, BatchBuilder> buildConsumer) {
        if (params == null) {
            throw new DomaNullPointerException("params");
        }
        if (buildConsumer == null) {
            throw new DomaNullPointerException("buildConsumer");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("execute");
        }
        BatchBuilder builder = BatchBuilder.newInstance(this.query);
        for (P p : params) {
            buildConsumer.accept(p, builder);
            builder = builder.fixSql();
        }
        return builder.execute(() -> new BatchDeleteCommand(this.query));
    }

    public List<? extends Sql<?>> getSqls() {
        return this.query.getSqls();
    }
}

