/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.builder.Param;

class BuildingHelper {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final LinkedList<Item> items = new LinkedList();

    BuildingHelper() {
    }

    void appendSql(String sql) {
        this.items.add(Item.sql(sql));
    }

    void appendSqlWithLineSeparator(String sql) {
        if (this.items.isEmpty()) {
            this.items.add(Item.sql(sql));
        } else {
            this.items.add(Item.sql(lineSeparator + sql));
        }
    }

    void appendParam(Param param) {
        this.items.add(Item.param(param));
    }

    void removeLast() {
        if (!this.items.isEmpty()) {
            this.items.removeLast();
        }
    }

    List<Param> getParams() {
        ArrayList<Param> results = new ArrayList<Param>();
        for (Item item : this.items) {
            if (item.kind != ItemKind.PARAM) continue;
            results.add(item.param);
        }
        return results;
    }

    SqlNode getSqlNode() {
        StringBuilder buf = new StringBuilder(200);
        block4: for (Item item : this.items) {
            switch (item.kind) {
                case SQL: {
                    buf.append(item.sql);
                    continue block4;
                }
                case PARAM: {
                    buf.append("/*");
                    if (item.param.literal) {
                        buf.append("^");
                    }
                    buf.append(item.param.name);
                    buf.append("*/0");
                    continue block4;
                }
            }
            AssertionUtil.assertUnreachable();
        }
        SqlParser parser = new SqlParser(buf.toString());
        return parser.parse();
    }

    private static class Item {
        private ItemKind kind;
        private String sql;
        private Param param;

        private Item() {
        }

        public static Item sql(String sql) {
            Item item = new Item();
            item.kind = ItemKind.SQL;
            item.sql = sql;
            return item;
        }

        public static Item param(Param param) {
            Item item = new Item();
            item.kind = ItemKind.PARAM;
            item.param = param;
            return item;
        }
    }

    private static enum ItemKind {
        SQL,
        PARAM;

    }
}

