/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.PreparedSqlParameterBinder;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.OptimisticLockException;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionException;
import org.seasar.doma.jdbc.UniqueConstraintException;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.query.ModifyQuery;
import org.seasar.doma.jdbc.query.Query;

public abstract class ModifyCommand<QUERY extends ModifyQuery>
implements Command<Integer> {
    protected final QUERY query;
    protected final PreparedSql sql;

    protected ModifyCommand(QUERY query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
        this.sql = query.getSql();
    }

    public QUERY getQuery() {
        return this.query;
    }

    /*
     * Loose catch block
     */
    @Override
    public Integer execute() {
        if (!this.query.isExecutable()) {
            JdbcLogger logger = this.query.getConfig().getJdbcLogger();
            logger.logSqlExecutionSkipping(this.query.getClassName(), this.query.getMethodName(), this.query.getSqlExecutionSkipCause());
            return 0;
        }
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection);
            try {
                this.log();
                this.setupOptions(preparedStatement);
                this.bindParameters(preparedStatement);
                Integer n = this.executeInternal(preparedStatement);
                return n;
            }
            catch (SQLException e) {
                Dialect dialect = this.query.getConfig().getDialect();
                throw new SqlExecutionException(this.query.getConfig().getExceptionSqlLogType(), this.sql, e, dialect.getRootCause(e));
            }
            finally {
                JdbcUtil.close(preparedStatement, this.query.getConfig().getJdbcLogger());
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        if (this.query.isAutoGeneratedKeysSupported()) {
            Config config = this.query.getConfig();
            Dialect dialect = config.getDialect();
            switch (dialect.getAutoGeneratedKeysType()) {
                case FIRST_COLUMN: {
                    return JdbcUtil.prepareStatementForAutoGeneratedKeysOfFirstColumn(connection, this.sql);
                }
                case DEFAULT: {
                    return JdbcUtil.prepareStatementForAutoGeneratedKeys(connection, this.sql);
                }
            }
        }
        return JdbcUtil.prepareStatement(connection, this.sql);
    }

    protected abstract int executeInternal(PreparedStatement var1) throws SQLException;

    protected void log() {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), this.sql);
    }

    protected void setupOptions(PreparedStatement preparedStatement) throws SQLException {
        if (this.query.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected void bindParameters(PreparedStatement preparedStatement) throws SQLException {
        PreparedSqlParameterBinder binder = new PreparedSqlParameterBinder((Query)this.query);
        binder.bind(preparedStatement, this.sql.getParameters());
    }

    protected int executeUpdate(PreparedStatement preparedStatement) throws SQLException {
        try {
            int updatedRows = preparedStatement.executeUpdate();
            this.validateRows(updatedRows);
            return updatedRows;
        }
        catch (SQLException e) {
            Dialect dialect = this.query.getConfig().getDialect();
            if (dialect.isUniqueConstraintViolated(e)) {
                throw new UniqueConstraintException(this.query.getConfig().getExceptionSqlLogType(), this.sql, e);
            }
            throw e;
        }
    }

    protected void validateRows(int rows) {
        if (this.query.isOptimisticLockCheckRequired() && rows == 0) {
            throw new OptimisticLockException(this.query.getConfig().getExceptionSqlLogType(), this.sql);
        }
    }
}

