/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.command;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.seasar.doma.FetchType;
import org.seasar.doma.internal.jdbc.command.PreparedSqlParameterBinder;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.OptimisticLockException;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.SqlExecutionException;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.ResultSetHandler;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.query.ModifyQuery;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.SelectQuery;

public abstract class ModifyReturningCommand<QUERY extends ModifyQuery, RESULT>
implements Command<RESULT> {
    protected final QUERY query;
    protected final PreparedSql sql;
    protected final ResultSetHandler<RESULT> resultSetHandler;
    protected final Supplier<RESULT> emptyResultSupplier;

    protected ModifyReturningCommand(QUERY query, ResultSetHandler<RESULT> resultSetHandler, Supplier<RESULT> emptyResultSupplier) {
        AssertionUtil.assertNotNull(query, resultSetHandler, emptyResultSupplier);
        this.query = query;
        this.sql = query.getSql();
        this.resultSetHandler = resultSetHandler;
        this.emptyResultSupplier = emptyResultSupplier;
    }

    public QUERY getQuery() {
        return this.query;
    }

    /*
     * Loose catch block
     */
    @Override
    public RESULT execute() {
        if (!this.query.isExecutable()) {
            JdbcLogger logger = this.query.getConfig().getJdbcLogger();
            logger.logSqlExecutionSkipping(this.query.getClassName(), this.query.getMethodName(), this.query.getSqlExecutionSkipCause());
            return this.emptyResultSupplier.get();
        }
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            RESULT RESULT;
            PreparedStatement preparedStatement = this.prepareStatement(connection);
            try {
                this.log();
                this.setupOptions(preparedStatement);
                this.bindParameters(preparedStatement);
                RESULT = this.executeInternal(preparedStatement);
            }
            catch (SQLException e) {
                Dialect dialect = this.query.getConfig().getDialect();
                throw new SqlExecutionException(this.query.getConfig().getExceptionSqlLogType(), this.sql, e, dialect.getRootCause(e));
            }
            finally {
                JdbcUtil.close(preparedStatement, this.query.getConfig().getJdbcLogger());
            }
            return RESULT;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        return JdbcUtil.prepareStatement(connection, this.sql);
    }

    protected abstract RESULT executeInternal(PreparedStatement var1) throws SQLException;

    protected void log() {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), this.sql);
    }

    protected void setupOptions(PreparedStatement preparedStatement) throws SQLException {
        if (this.query.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected void bindParameters(PreparedStatement preparedStatement) throws SQLException {
        PreparedSqlParameterBinder binder = new PreparedSqlParameterBinder((Query)this.query);
        binder.bind(preparedStatement, this.sql.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RESULT executeQuery(PreparedStatement preparedStatement) throws SQLException {
        Supplier<RESULT> supplier;
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            supplier = this.handleResultSet(resultSet);
        }
        finally {
            JdbcUtil.close(resultSet, this.query.getConfig().getJdbcLogger());
        }
        return supplier.get();
    }

    protected Supplier<RESULT> handleResultSet(ResultSet resultSet) throws SQLException {
        return this.resultSetHandler.handle(resultSet, new ReturningQuery(), (index, next) -> {
            if (index == -1L && !next.booleanValue() && this.query.isOptimisticLockCheckRequired()) {
                throw new OptimisticLockException(this.query.getConfig().getExceptionSqlLogType(), this.sql);
            }
        });
    }

    class ReturningQuery
    implements SelectQuery {
        ReturningQuery() {
        }

        @Override
        public PreparedSql getSql() {
            return ModifyReturningCommand.this.sql;
        }

        @Override
        public SelectOptions getOptions() {
            return SelectOptions.get();
        }

        @Override
        public boolean isResultEnsured() {
            return true;
        }

        @Override
        public boolean isResultMappingEnsured() {
            return false;
        }

        @Override
        public FetchType getFetchType() {
            return FetchType.EAGER;
        }

        @Override
        public int getFetchSize() {
            return ModifyReturningCommand.this.query.getConfig().getFetchSize();
        }

        @Override
        public int getMaxRows() {
            return ModifyReturningCommand.this.query.getConfig().getMaxRows();
        }

        @Override
        public SqlLogType getSqlLogType() {
            return ModifyReturningCommand.this.query.getSqlLogType();
        }

        @Override
        public boolean isResultStream() {
            return false;
        }

        @Override
        public String getClassName() {
            return ModifyReturningCommand.this.query.getClassName();
        }

        @Override
        public String getMethodName() {
            return ModifyReturningCommand.this.query.getMethodName();
        }

        @Override
        public Method getMethod() {
            return ModifyReturningCommand.this.query.getMethod();
        }

        @Override
        public Config getConfig() {
            return ModifyReturningCommand.this.query.getConfig();
        }

        @Override
        public int getQueryTimeout() {
            return ModifyReturningCommand.this.query.getQueryTimeout();
        }

        @Override
        public void prepare() {
        }

        @Override
        public void complete() {
        }

        @Override
        public String comment(String sql) {
            return ModifyReturningCommand.this.query.comment(sql);
        }
    }
}

