/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.criteria.WithQueryDsl;
import org.seasar.doma.jdbc.criteria.context.DeleteSettings;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.context.SelectSettings;
import org.seasar.doma.jdbc.criteria.context.SetOperationContext;
import org.seasar.doma.jdbc.criteria.context.UpdateSettings;
import org.seasar.doma.jdbc.criteria.context.WithContext;
import org.seasar.doma.jdbc.criteria.declaration.SelectFromDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.SetOperand;
import org.seasar.doma.jdbc.criteria.statement.UnifiedDeleteStarting;
import org.seasar.doma.jdbc.criteria.statement.UnifiedInsertStarting;
import org.seasar.doma.jdbc.criteria.statement.UnifiedSelectStarting;
import org.seasar.doma.jdbc.criteria.statement.UnifiedUpdateStarting;

public class QueryDsl {
    private final Config config;

    public QueryDsl(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public static QueryDsl of(Object provider) {
        return new QueryDsl(Config.get(provider));
    }

    public WithQueryDsl with(EntityMetamodel<?> entityMetamodel, SetOperand<?> subQuery) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(subQuery);
        List<WithContext> withContexts = List.of(new WithContext(entityMetamodel, subQuery));
        return this.with(withContexts);
    }

    public WithQueryDsl with(List<WithContext> withContexts) {
        Objects.requireNonNull(withContexts);
        return new WithQueryDsl(this.config, withContexts);
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        return this.from(entityMetamodel, null, settings -> {});
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel, Consumer<SelectSettings> settingsConsumer) {
        return this.from(entityMetamodel, null, settingsConsumer);
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel, SetOperand<?> setOperandForSubQuery) {
        return this.from(entityMetamodel, setOperandForSubQuery, settings -> {});
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel, SetOperand<?> setOperandForSubQuery, Consumer<SelectSettings> settingsConsumer) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(settingsConsumer);
        SetOperationContext<?> setOperationContextForSubQuery = setOperandForSubQuery == null ? null : setOperandForSubQuery.getContext();
        SelectContext context = new SelectContext(entityMetamodel, Optional.ofNullable(setOperationContextForSubQuery));
        settingsConsumer.accept(context.getSettings());
        SelectFromDeclaration declaration = new SelectFromDeclaration(context);
        return new UnifiedSelectStarting<ENTITY>(this.config, declaration, entityMetamodel);
    }

    public <ENTITY> UnifiedUpdateStarting<ENTITY> update(EntityMetamodel<ENTITY> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        return this.update(entityMetamodel, settings -> {});
    }

    public <ENTITY> UnifiedUpdateStarting<ENTITY> update(EntityMetamodel<ENTITY> entityMetamodel, Consumer<UpdateSettings> settingsConsumer) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(settingsConsumer);
        UpdateSettings settings = new UpdateSettings();
        settingsConsumer.accept(settings);
        return new UnifiedUpdateStarting<ENTITY>(this.config, entityMetamodel, settings);
    }

    public <ENTITY> UnifiedDeleteStarting<ENTITY> delete(EntityMetamodel<ENTITY> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        return this.delete(entityMetamodel, settings -> {});
    }

    public <ENTITY> UnifiedDeleteStarting<ENTITY> delete(EntityMetamodel<ENTITY> entityMetamodel, Consumer<DeleteSettings> settingsConsumer) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(settingsConsumer);
        DeleteSettings settings = new DeleteSettings();
        settingsConsumer.accept(settings);
        return new UnifiedDeleteStarting<ENTITY>(this.config, entityMetamodel, settings);
    }

    public <ENTITY> UnifiedInsertStarting<ENTITY> insert(EntityMetamodel<ENTITY> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        return this.insert(entityMetamodel, settings -> {});
    }

    public <ENTITY> UnifiedInsertStarting<ENTITY> insert(EntityMetamodel<ENTITY> entityMetamodel, Consumer<InsertSettings> settingsConsumer) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(settingsConsumer);
        InsertSettings settings = new InsertSettings();
        settingsConsumer.accept(settings);
        return new UnifiedInsertStarting<ENTITY>(this.config, entityMetamodel, settings);
    }
}

