/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.context.SelectSettings;
import org.seasar.doma.jdbc.criteria.context.SetOperationContext;
import org.seasar.doma.jdbc.criteria.context.WithContext;
import org.seasar.doma.jdbc.criteria.declaration.SelectFromDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.SetOperand;
import org.seasar.doma.jdbc.criteria.statement.UnifiedSelectStarting;

public class WithQueryDsl {
    private final Config config;
    private final ArrayList<WithContext> withContexts;

    public WithQueryDsl(Config config, List<WithContext> withContexts) {
        this.config = Objects.requireNonNull(config);
        Objects.requireNonNull(withContexts);
        this.withContexts = new ArrayList<WithContext>(withContexts);
    }

    public WithQueryDsl with(EntityMetamodel<?> entityMetamodel, SetOperand<?> subQuery) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(subQuery);
        WithContext withContext = new WithContext(entityMetamodel, subQuery);
        this.withContexts.add(withContext);
        return this;
    }

    public WithQueryDsl with(List<WithContext> withContexts) {
        Objects.requireNonNull(withContexts);
        this.withContexts.addAll(withContexts);
        return this;
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        return this.from(entityMetamodel, null, settings -> {});
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel, Consumer<SelectSettings> settingsConsumer) {
        return this.from(entityMetamodel, null, settingsConsumer);
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel, SetOperand<?> setOperandForSubQuery) {
        return this.from(entityMetamodel, setOperandForSubQuery, settings -> {});
    }

    public <ENTITY> UnifiedSelectStarting<ENTITY> from(EntityMetamodel<ENTITY> entityMetamodel, SetOperand<?> setOperandForSubQuery, Consumer<SelectSettings> settingsConsumer) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(settingsConsumer);
        SetOperationContext<?> setOperationContextForSubQuery = setOperandForSubQuery == null ? null : setOperandForSubQuery.getContext();
        SelectContext context = new SelectContext(entityMetamodel, Optional.ofNullable(setOperationContextForSubQuery), this.withContexts);
        settingsConsumer.accept(context.getSettings());
        SelectFromDeclaration declaration = new SelectFromDeclaration(context);
        return new UnifiedSelectStarting<ENTITY>(this.config, declaration, entityMetamodel);
    }
}

