/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.command;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.seasar.doma.internal.util.Combinations;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.EntityId;
import org.seasar.doma.jdbc.EntityRef;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.criteria.command.EntityData;
import org.seasar.doma.jdbc.criteria.command.EntityKey;
import org.seasar.doma.jdbc.criteria.command.EntityPool;
import org.seasar.doma.jdbc.criteria.command.EntityPoolIterationHandler;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.SelectQuery;

public class AssociateCommand<ENTITY>
implements Command<List<ENTITY>> {
    private final SelectContext context;
    private final SelectQuery query;
    private final EntityMetamodel<ENTITY> entityMetamodel;

    public AssociateCommand(SelectContext context, SelectQuery query, EntityMetamodel<ENTITY> entityMetamodel) {
        this.context = Objects.requireNonNull(context);
        this.query = Objects.requireNonNull(query);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
    }

    @Override
    public List<ENTITY> execute() {
        LinkedHashSet<EntityId> rootEntityIds = new LinkedHashSet<EntityId>();
        HashMap<EntityId, EntityRef> cache = new HashMap<EntityId, EntityRef>();
        Combinations<EntityKey> combinations = new Combinations<EntityKey>();
        SelectCommand<List<EntityPool>> command = new SelectCommand<List<EntityPool>>(this.query, new EntityPoolIterationHandler(this.entityMetamodel, rootEntityIds, this.context.getProjectionEntityMetamodels()));
        List<EntityPool> entityPools = command.execute();
        for (EntityPool entityPool : entityPools) {
            LinkedHashMap associationCandidate = new LinkedHashMap();
            for (Map.Entry<EntityKey, EntityData> e : entityPool.entrySet()) {
                EntityKey key = e.getKey();
                EntityData data = e.getValue();
                EntityId entityId = key.asEntityId();
                EntityRef entityRef = cache.computeIfAbsent(entityId, k -> {
                    EntityType<?> entityType = k.entityType();
                    Object entity = entityType.newEntity(data.getStates());
                    if (!entityType.isImmutable()) {
                        entityType.saveCurrentStates(entity);
                    }
                    return new EntityRef(entity);
                });
                associationCandidate.put(key.getEntityMetamodel(), new Pair<EntityKey, EntityRef>(key, entityRef));
            }
            this.associate(combinations, associationCandidate);
        }
        return rootEntityIds.stream().map(cache::get).map(EntityRef::getEntity).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void associate(Combinations<EntityKey> combinations, Map<EntityMetamodel<?>, Pair<EntityKey, EntityRef>> associationCandidate) {
        for (Map.Entry<Pair<EntityMetamodel<?>, EntityMetamodel<?>>, BiFunction<Object, Object, Object>> e : this.context.associations.entrySet()) {
            Object targetEntity;
            Pair<EntityKey, EntityKey> keyPair;
            Pair<EntityMetamodel<?>, EntityMetamodel<?>> metamodelPair = e.getKey();
            BiFunction<Object, Object, Object> associator = e.getValue();
            Pair<EntityKey, EntityRef> source = associationCandidate.get(metamodelPair.fst);
            Pair<EntityKey, EntityRef> target = associationCandidate.get(metamodelPair.snd);
            if (source == null || target == null || combinations.contains(keyPair = new Pair<EntityKey, EntityKey>((EntityKey)source.fst, (EntityKey)target.fst))) continue;
            EntityRef sourceEntityRef = (EntityRef)source.snd;
            EntityRef targetEntityRef = (EntityRef)target.snd;
            Object sourceEntity = sourceEntityRef.getEntity();
            Object resultEntity = associator.apply(sourceEntity, targetEntity = targetEntityRef.getEntity());
            if (resultEntity != null && resultEntity != sourceEntity) {
                sourceEntityRef.setEntity(resultEntity);
            }
            combinations.add(keyPair);
        }
    }

    @Override
    public Query getQuery() {
        return this.query;
    }
}

