/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.command;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.seasar.doma.internal.jdbc.command.AbstractIterationHandler;
import org.seasar.doma.internal.jdbc.command.ResultListCallback;
import org.seasar.doma.jdbc.EntityId;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.criteria.command.EntityPool;
import org.seasar.doma.jdbc.criteria.command.EntityPoolProvider;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.query.SelectQuery;

public class EntityPoolIterationHandler
extends AbstractIterationHandler<EntityPool, List<EntityPool>> {
    private final EntityMetamodel<?> rootEntityMetamodel;
    private final Set<EntityId> rootEntityIds;
    private final Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> projectionEntityMetamodels;

    public EntityPoolIterationHandler(EntityMetamodel<?> rootEntityMetamodel, Set<EntityId> rootEntityIds, Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> projectionEntityMetamodels) {
        super(new ResultListCallback());
        this.rootEntityMetamodel = Objects.requireNonNull(rootEntityMetamodel);
        this.rootEntityIds = Objects.requireNonNull(rootEntityIds);
        this.projectionEntityMetamodels = Objects.requireNonNull(projectionEntityMetamodels);
    }

    @Override
    protected ObjectProvider<EntityPool> createObjectProvider(SelectQuery query) {
        return new EntityPoolProvider(this.rootEntityMetamodel, this.rootEntityIds, this.projectionEntityMetamodels, query);
    }
}

