/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.context;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.declaration.UserDefinedCriteriaContext;
import org.seasar.doma.jdbc.criteria.option.LikeOption;
import org.seasar.doma.jdbc.criteria.tuple.Tuple2;
import org.seasar.doma.jdbc.criteria.tuple.Tuple3;

public interface Criterion {
    public void accept(Visitor var1);

    public static interface Visitor {
        public void visit(Eq var1);

        public void visit(Ne var1);

        public void visit(Gt var1);

        public void visit(Ge var1);

        public void visit(Lt var1);

        public void visit(Le var1);

        public void visit(IsNull var1);

        public void visit(IsNotNull var1);

        public void visit(Like var1);

        public void visit(NotLike var1);

        public void visit(Between var1);

        public void visit(In var1);

        public void visit(NotIn var1);

        public void visit(InSubQuery var1);

        public void visit(NotInSubQuery var1);

        public void visit(InTuple2 var1);

        public void visit(NotInTuple2 var1);

        public void visit(InTuple2SubQuery var1);

        public void visit(NotInTuple2SubQuery var1);

        public void visit(InTuple3 var1);

        public void visit(NotInTuple3 var1);

        public void visit(InTuple3SubQuery var1);

        public void visit(NotInTuple3SubQuery var1);

        public void visit(Exists var1);

        public void visit(NotExists var1);

        public void visit(And var1);

        public void visit(Or var1);

        public void visit(Not var1);

        public void visit(UserDefined var1);
    }

    public static class UserDefined
    implements Criterion {
        public final Consumer<UserDefinedCriteriaContext.Builder> builderBlock;

        public UserDefined(Consumer<UserDefinedCriteriaContext.Builder> builderBlock) {
            Objects.requireNonNull(builderBlock);
            this.builderBlock = builderBlock;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Not
    implements Criterion {
        public final List<Criterion> criterionList;

        public Not(List<Criterion> criterionList) {
            Objects.requireNonNull(criterionList);
            this.criterionList = Collections.unmodifiableList(criterionList);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Or
    implements Criterion {
        public final List<Criterion> criterionList;

        public Or(List<Criterion> criterionList) {
            Objects.requireNonNull(criterionList);
            this.criterionList = Collections.unmodifiableList(criterionList);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class And
    implements Criterion {
        public final List<Criterion> criterionList;

        public And(List<Criterion> criterionList) {
            Objects.requireNonNull(criterionList);
            this.criterionList = Collections.unmodifiableList(criterionList);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotExists
    implements Criterion {
        public final SelectContext context;

        public NotExists(SelectContext context) {
            this.context = Objects.requireNonNull(context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Exists
    implements Criterion {
        public final SelectContext context;

        public Exists(SelectContext context) {
            this.context = Objects.requireNonNull(context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotInTuple3SubQuery
    implements Criterion {
        public final Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left;
        public final SelectContext right;

        public NotInTuple3SubQuery(Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left, SelectContext right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class InTuple3SubQuery
    implements Criterion {
        public final Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left;
        public final SelectContext right;

        public InTuple3SubQuery(Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left, SelectContext right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotInTuple3
    implements Criterion {
        public final Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left;
        public final List<Tuple3<Operand.Param, Operand.Param, Operand.Param>> right;

        public NotInTuple3(Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left, List<Tuple3<Operand.Param, Operand.Param, Operand.Param>> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class InTuple3
    implements Criterion {
        public final Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left;
        public final List<Tuple3<Operand.Param, Operand.Param, Operand.Param>> right;

        public InTuple3(Tuple3<Operand.Prop, Operand.Prop, Operand.Prop> left, List<Tuple3<Operand.Param, Operand.Param, Operand.Param>> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotInTuple2SubQuery
    implements Criterion {
        public final Tuple2<Operand.Prop, Operand.Prop> left;
        public final SelectContext right;

        public NotInTuple2SubQuery(Tuple2<Operand.Prop, Operand.Prop> left, SelectContext right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class InTuple2SubQuery
    implements Criterion {
        public final Tuple2<Operand.Prop, Operand.Prop> left;
        public final SelectContext right;

        public InTuple2SubQuery(Tuple2<Operand.Prop, Operand.Prop> left, SelectContext right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotInTuple2
    implements Criterion {
        public final Tuple2<Operand.Prop, Operand.Prop> left;
        public final List<Tuple2<Operand.Param, Operand.Param>> right;

        public NotInTuple2(Tuple2<Operand.Prop, Operand.Prop> left, List<Tuple2<Operand.Param, Operand.Param>> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class InTuple2
    implements Criterion {
        public final Tuple2<Operand.Prop, Operand.Prop> left;
        public final List<Tuple2<Operand.Param, Operand.Param>> right;

        public InTuple2(Tuple2<Operand.Prop, Operand.Prop> left, List<Tuple2<Operand.Param, Operand.Param>> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotInSubQuery
    implements Criterion {
        public final Operand.Prop left;
        public final SelectContext right;

        public NotInSubQuery(Operand.Prop left, SelectContext right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class InSubQuery
    implements Criterion {
        public final Operand.Prop left;
        public final SelectContext right;

        public InSubQuery(Operand.Prop left, SelectContext right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotIn
    implements Criterion {
        public final Operand.Prop left;
        public final List<Operand.Param> right;

        public NotIn(Operand.Prop left, List<Operand.Param> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class In
    implements Criterion {
        public final Operand.Prop left;
        public final List<Operand.Param> right;

        public In(Operand.Prop left, List<Operand.Param> right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Between
    implements Criterion {
        public final Operand.Prop prop;
        public final Operand.Param start;
        public final Operand.Param end;

        public Between(Operand.Prop prop, Operand.Param start, Operand.Param end) {
            this.prop = Objects.requireNonNull(prop);
            this.start = Objects.requireNonNull(start);
            this.end = Objects.requireNonNull(end);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NotLike
    implements Criterion {
        public final Operand.Prop left;
        public final CharSequence right;
        public final LikeOption option;

        public NotLike(Operand.Prop left, CharSequence right, LikeOption option) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
            this.option = Objects.requireNonNull(option);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Like
    implements Criterion {
        public final Operand.Prop left;
        public final CharSequence right;
        public final LikeOption option;

        public Like(Operand.Prop left, CharSequence right, LikeOption option) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
            this.option = Objects.requireNonNull(option);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class IsNotNull
    implements Criterion {
        public final Operand.Prop prop;

        public IsNotNull(Operand.Prop prop) {
            this.prop = Objects.requireNonNull(prop);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class IsNull
    implements Criterion {
        public final Operand.Prop prop;

        public IsNull(Operand.Prop prop) {
            this.prop = Objects.requireNonNull(prop);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Le
    implements Criterion {
        public final Operand.Prop left;
        public final Operand right;

        public Le(Operand.Prop left, Operand right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Lt
    implements Criterion {
        public final Operand.Prop left;
        public final Operand right;

        public Lt(Operand.Prop left, Operand right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Ge
    implements Criterion {
        public final Operand.Prop left;
        public final Operand right;

        public Ge(Operand.Prop left, Operand right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Gt
    implements Criterion {
        public final Operand.Prop left;
        public final Operand right;

        public Gt(Operand.Prop left, Operand right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Ne
    implements Criterion {
        public final Operand.Prop left;
        public final Operand right;

        public Ne(Operand.Prop left, Operand right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Eq
    implements Criterion {
        public final Operand.Prop left;
        public final Operand right;

        public Eq(Operand.Prop left, Operand right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }
}

