/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.criteria.context.Context;
import org.seasar.doma.jdbc.criteria.context.Criterion;
import org.seasar.doma.jdbc.criteria.context.ForUpdate;
import org.seasar.doma.jdbc.criteria.context.Join;
import org.seasar.doma.jdbc.criteria.context.OrderByItem;
import org.seasar.doma.jdbc.criteria.context.Projection;
import org.seasar.doma.jdbc.criteria.context.SelectSettings;
import org.seasar.doma.jdbc.criteria.context.SetOperationContext;
import org.seasar.doma.jdbc.criteria.context.WithContext;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.DistinctOption;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;

public class SelectContext
implements Context {
    public final EntityMetamodel<?> entityMetamodel;
    public final List<WithContext> withContexts;
    public Projection projection;
    public DistinctOption distinct = DistinctOption.none();
    public final List<Join> joins = new ArrayList<Join>();
    public List<Criterion> where = new ArrayList<Criterion>();
    public final List<PropertyMetamodel<?>> groupBy = new ArrayList();
    public List<Criterion> having = new ArrayList<Criterion>();
    public final List<Pair<OrderByItem, String>> orderBy = new ArrayList<Pair<OrderByItem, String>>();
    public Integer limit;
    public Integer offset;
    public ForUpdate forUpdate = new ForUpdate(ForUpdateOption.none());
    public final Map<Pair<EntityMetamodel<?>, EntityMetamodel<?>>, BiFunction<Object, Object, Object>> associations = new LinkedHashMap();
    public final SelectSettings settings = new SelectSettings();
    public Optional<SetOperationContext<?>> setOperationContextForSubQuery;

    public SelectContext(EntityMetamodel<?> entityMetamodel, Optional<SetOperationContext<?>> setOperationContextForSubQuery) {
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.setOperationContextForSubQuery = Objects.requireNonNull(setOperationContextForSubQuery);
        this.projection = new Projection.EntityMetamodels(entityMetamodel);
        this.withContexts = new ArrayList<WithContext>();
    }

    public SelectContext(EntityMetamodel<?> entityMetamodel, Optional<SetOperationContext<?>> setOperationContextForSubQuery, List<WithContext> withContexts) {
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.setOperationContextForSubQuery = Objects.requireNonNull(setOperationContextForSubQuery);
        this.projection = new Projection.EntityMetamodels(entityMetamodel);
        this.withContexts = Objects.requireNonNull(withContexts);
    }

    @Override
    public List<EntityMetamodel<?>> getEntityMetamodels() {
        ArrayList entityMetamodels = new ArrayList();
        entityMetamodels.add(this.entityMetamodel);
        List joinedEntityMetamodels = this.joins.stream().map(j -> j.entityMetamodel).collect(Collectors.toList());
        entityMetamodels.addAll(joinedEntityMetamodels);
        return entityMetamodels;
    }

    @Override
    public SelectSettings getSettings() {
        return this.settings;
    }

    public Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> getProjectionEntityMetamodels() {
        return (Map)this.projection.accept(new Projection.Visitor<Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>>>(){

            @Override
            public Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> visit(Projection.EntityMetamodels entityMetamodels) {
                LinkedHashMap map = new LinkedHashMap(entityMetamodels.map);
                SelectContext.this.associations.keySet().stream().flatMap(pair -> Stream.of((EntityMetamodel)pair.fst, (EntityMetamodel)pair.snd)).forEach(it -> {
                    if (!map.containsKey(it)) {
                        map.put((EntityMetamodel<?>)it, it.allPropertyMetamodels());
                    }
                });
                return map;
            }

            @Override
            public Map<EntityMetamodel<?>, List<PropertyMetamodel<?>>> visit(Projection.PropertyMetamodels propertyMetamodels) {
                throw new IllegalStateException();
            }
        });
    }

    public List<PropertyMetamodel<?>> getProjectionPropertyMetamodels() {
        return (List)this.projection.accept(new Projection.Visitor<List<PropertyMetamodel<?>>>(){

            @Override
            public List<PropertyMetamodel<?>> visit(Projection.EntityMetamodels entityMetamodels) {
                return SelectContext.this.getProjectionEntityMetamodels().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }

            @Override
            public List<PropertyMetamodel<?>> visit(Projection.PropertyMetamodels propertyMetamodels) {
                return propertyMetamodels.propertyMetamodels;
            }
        });
    }
}

