/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.declaration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.seasar.doma.DomaException;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.criteria.context.ForUpdate;
import org.seasar.doma.jdbc.criteria.context.Join;
import org.seasar.doma.jdbc.criteria.context.JoinKind;
import org.seasar.doma.jdbc.criteria.context.Projection;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.declaration.HavingDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.JoinDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.OrderByNameDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.WhereDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.AssociationOption;
import org.seasar.doma.jdbc.criteria.option.DistinctOption;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SelectFromDeclaration {
    private final SelectContext context;

    public SelectFromDeclaration(SelectContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public SelectContext getContext() {
        return this.context;
    }

    public void distinct(DistinctOption distinctOption) {
        this.context.distinct = distinctOption;
    }

    public void innerJoin(EntityMetamodel<?> entityMetamodel, Consumer<JoinDeclaration> block) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(block);
        this.join(entityMetamodel, block, JoinKind.INNER);
    }

    public void leftJoin(EntityMetamodel<?> entityMetamodel, Consumer<JoinDeclaration> block) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(block);
        this.join(entityMetamodel, block, JoinKind.LEFT);
    }

    private void join(EntityMetamodel<?> entityMetamodel, Consumer<JoinDeclaration> block, JoinKind joinKind) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(block);
        Objects.requireNonNull(joinKind);
        Join join = new Join(entityMetamodel, joinKind);
        JoinDeclaration declaration = new JoinDeclaration(join);
        block.accept(declaration);
        if (!join.on.isEmpty()) {
            this.context.joins.add(join);
        }
    }

    public void where(Consumer<WhereDeclaration> block) {
        Objects.requireNonNull(block);
        WhereDeclaration declaration = new WhereDeclaration(this.context);
        block.accept(declaration);
    }

    public void groupBy(PropertyMetamodel<?> ... propertyMetamodels) {
        Objects.requireNonNull(propertyMetamodels);
        this.context.groupBy.addAll(Arrays.asList(propertyMetamodels));
    }

    public void having(Consumer<HavingDeclaration> block) {
        Objects.requireNonNull(block);
        HavingDeclaration declaration = new HavingDeclaration(this.context);
        block.accept(declaration);
    }

    public void orderBy(Consumer<OrderByNameDeclaration> block) {
        Objects.requireNonNull(block);
        OrderByNameDeclaration declaration = new OrderByNameDeclaration(this.context);
        block.accept(declaration);
    }

    public void limit(Integer limit) {
        this.context.limit = limit;
    }

    public void offset(Integer offset) {
        this.context.offset = offset;
    }

    public void forUpdate(ForUpdateOption option) {
        Objects.requireNonNull(option);
        this.context.forUpdate = new ForUpdate(option);
    }

    public void select(List<PropertyMetamodel<?>> propertyMetamodels) {
        Objects.requireNonNull(propertyMetamodels);
        int i = 0;
        for (PropertyMetamodel<?> propertyMetamodel : propertyMetamodels) {
            Objects.requireNonNull(propertyMetamodel, "propertyMetamodels: " + i);
        }
        this.context.projection = new Projection.PropertyMetamodels(propertyMetamodels);
    }

    public void select(EntityMetamodel<?> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        if (!this.context.getEntityMetamodels().contains(entityMetamodel)) {
            throw new DomaException((MessageResource)Message.DOMA6009, "entityMetamodel");
        }
        this.context.projection = new Projection.EntityMetamodels(entityMetamodel);
    }

    public void selectTo(EntityMetamodel<?> entityMetamodel, List<PropertyMetamodel<?>> propertyMetamodels) {
        Objects.requireNonNull(propertyMetamodels);
        if (!this.context.getEntityMetamodels().contains(entityMetamodel)) {
            throw new DomaException((MessageResource)Message.DOMA6007, "entityMetamodel");
        }
        int i = 0;
        for (PropertyMetamodel<?> propertyMetamodel : propertyMetamodels) {
            Objects.requireNonNull(propertyMetamodel, "propertyMetamodels: " + i);
            if (entityMetamodel.allPropertyMetamodels().contains(propertyMetamodel)) continue;
            throw new DomaException((MessageResource)Message.DOMA6008, i);
        }
        LinkedHashSet projectionTargets = new LinkedHashSet();
        EntityType<?> entityType = entityMetamodel.asType();
        List<EntityPropertyType<?, ?>> idPropertyTypes = entityType.getIdPropertyTypes();
        entityMetamodel.allPropertyMetamodels().stream().filter(it -> idPropertyTypes.contains(it.asType())).forEach(projectionTargets::add);
        projectionTargets.addAll(propertyMetamodels);
        this.context.projection = new Projection.EntityMetamodels(entityMetamodel, new ArrayList(projectionTargets));
    }

    public <ENTITY1, ENTITY2> void associate(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiConsumer<ENTITY1, ENTITY2> associator, AssociationOption option) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        Objects.requireNonNull(option);
        if (!this.context.getEntityMetamodels().contains(first)) {
            if (option == AssociationOption.Kind.MANDATORY) {
                throw new DomaException((MessageResource)Message.DOMA6001, "first");
            }
            return;
        }
        if (!this.context.getEntityMetamodels().contains(second)) {
            if (option == AssociationOption.Kind.MANDATORY) {
                throw new DomaException((MessageResource)Message.DOMA6001, "second");
            }
            return;
        }
        this.context.associations.put(new Pair<EntityMetamodel<ENTITY1>, EntityMetamodel<ENTITY2>>(first, second), (entity1, entity2) -> {
            associator.accept(entity1, entity2);
            return null;
        });
    }

    public <ENTITY1, ENTITY2> void associateWith(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiFunction<ENTITY1, ENTITY2, ENTITY1> associator, AssociationOption option) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        Objects.requireNonNull(option);
        if (!this.context.getEntityMetamodels().contains(first)) {
            if (option == AssociationOption.Kind.MANDATORY) {
                throw new DomaException((MessageResource)Message.DOMA6010, "first");
            }
            return;
        }
        if (!this.context.getEntityMetamodels().contains(second)) {
            if (option == AssociationOption.Kind.MANDATORY) {
                throw new DomaException((MessageResource)Message.DOMA6010, "second");
            }
            return;
        }
        this.context.associations.put(new Pair<EntityMetamodel<ENTITY1>, EntityMetamodel<ENTITY2>>(first, second), (entity1, entity2) -> associator.apply(entity1, entity2));
    }
}

