/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.criteria.expression.BigDecimalPropertyType;
import org.seasar.doma.jdbc.criteria.expression.BigIntegerPropertyType;
import org.seasar.doma.jdbc.criteria.expression.BooleanPropertyType;
import org.seasar.doma.jdbc.criteria.expression.BytePropertyType;
import org.seasar.doma.jdbc.criteria.expression.DoublePropertyType;
import org.seasar.doma.jdbc.criteria.expression.FloatPropertyType;
import org.seasar.doma.jdbc.criteria.expression.IntegerPropertyType;
import org.seasar.doma.jdbc.criteria.expression.LocalDatePropertyType;
import org.seasar.doma.jdbc.criteria.expression.LocalDateTimePropertyType;
import org.seasar.doma.jdbc.criteria.expression.LocalTimePropertyType;
import org.seasar.doma.jdbc.criteria.expression.LongPropertyType;
import org.seasar.doma.jdbc.criteria.expression.ShortPropertyType;
import org.seasar.doma.jdbc.criteria.expression.StringPropertyType;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public class UserDefinedExpression<PROPERTY>
implements PropertyMetamodel<PROPERTY> {
    private final String name;
    private final List<? extends PropertyMetamodel<?>> operands;
    private final Class<?> klass;
    private final EntityPropertyType<?, ?> type;
    private final Consumer<Declaration> block;

    UserDefinedExpression(Class<PROPERTY> klass, String name, List<? extends PropertyMetamodel<?>> operands, Consumer<Declaration> block) {
        this.klass = Objects.requireNonNull(klass);
        this.type = UserDefinedExpression.getTypeByKlass(this.klass);
        this.name = Objects.requireNonNull(name);
        this.operands = Objects.requireNonNull(operands);
        this.block = Objects.requireNonNull(block);
    }

    UserDefinedExpression(PropertyMetamodel<PROPERTY> resultPropertyMetamodel, String name, List<? extends PropertyMetamodel<?>> operands, Consumer<Declaration> block) {
        Objects.requireNonNull(resultPropertyMetamodel);
        this.klass = resultPropertyMetamodel.asClass();
        this.type = resultPropertyMetamodel.asType();
        this.name = Objects.requireNonNull(name);
        this.operands = Objects.requireNonNull(operands);
        this.block = Objects.requireNonNull(block);
    }

    public List<DeclarationItem> getDeclarationItems(Dialect dialect) {
        Declaration declaration = new Declaration(dialect);
        this.block.accept(declaration);
        return declaration.declarationItems;
    }

    @Override
    public Class<?> asClass() {
        return this.klass;
    }

    @Override
    public EntityPropertyType<?, ?> asType() {
        return this.type;
    }

    private static EntityPropertyType<?, ?> getTypeByKlass(Class<?> klass) {
        if (klass == BigDecimal.class) {
            return new BigDecimalPropertyType(null);
        }
        if (klass == BigInteger.class) {
            return new BigIntegerPropertyType(null);
        }
        if (klass == Boolean.class || klass == Boolean.TYPE) {
            return new BooleanPropertyType(null);
        }
        if (klass == Byte.class || klass == Byte.TYPE) {
            return new BytePropertyType(null);
        }
        if (klass == Double.class || klass == Double.TYPE) {
            return new DoublePropertyType(null);
        }
        if (klass == Float.class || klass == Float.TYPE) {
            return new FloatPropertyType(null);
        }
        if (klass == Integer.class || klass == Integer.TYPE) {
            return new IntegerPropertyType(null);
        }
        if (klass == LocalDate.class) {
            return new LocalDatePropertyType(null);
        }
        if (klass == LocalDateTime.class) {
            return new LocalDateTimePropertyType(null);
        }
        if (klass == LocalTime.class) {
            return new LocalTimePropertyType(null);
        }
        if (klass == Long.class || klass == Long.TYPE) {
            return new LongPropertyType(null);
        }
        if (klass == Short.class || klass == Short.TYPE) {
            return new ShortPropertyType(null);
        }
        if (klass == String.class) {
            return new StringPropertyType(null);
        }
        throw new UnsupportedOperationException("Does not support for " + klass.getName() + " type. if " + klass.getName() + " is a domain class, please use another constructor of UserDefinedExpression.");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void accept(PropertyMetamodel.Visitor visitor) {
        if (visitor instanceof Visitor) {
            Visitor v = (Visitor)((Object)visitor);
            v.visit(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedExpression that = (UserDefinedExpression)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.operands, that.operands) && Objects.equals(this.klass, that.klass);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.operands, this.klass);
    }

    public static class Declaration {
        private final ArrayList<DeclarationItem> declarationItems = new ArrayList();
        public final Dialect dialect;

        public Declaration(Dialect dialect) {
            Objects.requireNonNull(dialect);
            this.dialect = dialect;
        }

        public void appendSql(String sql) {
            Objects.requireNonNull(sql);
            this.declarationItems.add(new DeclarationItem.Sql(sql));
        }

        public void cutBackSql(int length) {
            this.declarationItems.add(new DeclarationItem.CutbackSql(length));
        }

        public void appendExpression(PropertyMetamodel<?> propertyMetamodel) {
            Objects.requireNonNull(propertyMetamodel);
            this.declarationItems.add(new DeclarationItem.Expression(propertyMetamodel));
        }
    }

    public static interface Visitor {
        public void visit(UserDefinedExpression<?> var1);
    }

    public static interface DeclarationItem {
        public void accept(Visitor var1);

        public static interface Visitor {
            public void visit(Sql var1);

            public void visit(Expression var1);

            public void visit(CutbackSql var1);
        }

        public static final class Expression
        implements DeclarationItem {
            private final PropertyMetamodel<?> propertyMetamodel;

            public Expression(PropertyMetamodel<?> propertyMetamodel) {
                this.propertyMetamodel = propertyMetamodel;
            }

            public PropertyMetamodel<?> get() {
                return this.propertyMetamodel;
            }

            @Override
            public void accept(Visitor visitor) {
                visitor.visit(this);
            }
        }

        public static final class CutbackSql
        implements DeclarationItem {
            private final int length;

            public CutbackSql(int length) {
                this.length = length;
            }

            public int get() {
                return this.length;
            }

            @Override
            public void accept(Visitor visitor) {
                visitor.visit(this);
            }
        }

        public static final class Sql
        implements DeclarationItem {
            private final String sql;

            public Sql(String sql) {
                this.sql = sql;
            }

            public String get() {
                return this.sql;
            }

            @Override
            public void accept(Visitor visitor) {
                visitor.visit(this);
            }
        }
    }
}

