/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.option;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;

public interface ForUpdateOption {
    public static ForUpdateOption none() {
        return None.INSTANCE;
    }

    public static ForUpdateOption basic(PropertyMetamodel<?> ... propertyMetamodels) {
        Objects.requireNonNull(propertyMetamodels);
        return new Basic(Arrays.asList(propertyMetamodels));
    }

    public static ForUpdateOption noWait(PropertyMetamodel<?> ... propertyMetamodels) {
        Objects.requireNonNull(propertyMetamodels);
        return new NoWait(Arrays.asList(propertyMetamodels));
    }

    public static ForUpdateOption wait(int seconds, PropertyMetamodel<?> ... propertyMetamodels) {
        Objects.requireNonNull(propertyMetamodels);
        return new Wait(seconds, Arrays.asList(propertyMetamodels));
    }

    public void accept(Visitor var1);

    public static class None
    implements ForUpdateOption {
        private static final None INSTANCE = new None();

        private None() {
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static class Basic
    implements ForUpdateOption {
        public final List<PropertyMetamodel<?>> propertyMetamodels;

        public Basic(List<PropertyMetamodel<?>> propertyMetamodels) {
            Objects.requireNonNull(propertyMetamodels);
            this.propertyMetamodels = Collections.unmodifiableList(propertyMetamodels);
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static class NoWait
    implements ForUpdateOption {
        public final List<PropertyMetamodel<?>> propertyMetamodels;

        public NoWait(List<PropertyMetamodel<?>> propertyMetamodels) {
            Objects.requireNonNull(propertyMetamodels);
            this.propertyMetamodels = Collections.unmodifiableList(propertyMetamodels);
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static class Wait
    implements ForUpdateOption {
        public final int second;
        public final List<PropertyMetamodel<?>> propertyMetamodels;

        public Wait(int second, List<PropertyMetamodel<?>> propertyMetamodels) {
            Objects.requireNonNull(propertyMetamodels);
            this.second = second;
            this.propertyMetamodels = Collections.unmodifiableList(propertyMetamodels);
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static interface Visitor {
        default public void visit(None none) {
        }

        public void visit(Basic var1);

        public void visit(NoWait var1);

        public void visit(Wait var1);
    }
}

