/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.option;

import java.util.Objects;

public interface LikeOption {
    public static final char DEFAULT_ESCAPE_CHAR = '$';

    public static LikeOption none() {
        return None.INSTANCE;
    }

    public static LikeOption escape() {
        return new Escape('$');
    }

    public static LikeOption escape(char escapeChar) {
        return new Escape(escapeChar);
    }

    public static LikeOption prefix() {
        return new Prefix('$');
    }

    public static LikeOption prefix(char escapeChar) {
        return new Prefix(escapeChar);
    }

    public static LikeOption infix() {
        return new Infix('$');
    }

    public static LikeOption infix(char escapeChar) {
        return new Infix(escapeChar);
    }

    public static LikeOption suffix() {
        return new Suffix('$');
    }

    public static LikeOption suffix(char escapeChar) {
        return new Suffix(escapeChar);
    }

    public void accept(Visitor var1);

    public static class None
    implements LikeOption {
        private static final None INSTANCE = new None();

        private None() {
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static class Escape
    implements LikeOption {
        public final char escapeChar;

        public Escape(char escapeChar) {
            this.escapeChar = escapeChar;
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static class Prefix
    implements LikeOption {
        public final char escapeChar;

        public Prefix(char escapeChar) {
            this.escapeChar = escapeChar;
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static class Infix
    implements LikeOption {
        public final char escapeChar;

        public Infix(char escapeChar) {
            this.escapeChar = escapeChar;
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static class Suffix
    implements LikeOption {
        public final char escapeChar;

        public Suffix(char escapeChar) {
            this.escapeChar = escapeChar;
        }

        @Override
        public void accept(Visitor visitor) {
            Objects.requireNonNull(visitor);
            visitor.visit(this);
        }
    }

    public static interface Visitor {
        public void visit(None var1);

        public void visit(Escape var1);

        public void visit(Prefix var1);

        public void visit(Infix var1);

        public void visit(Suffix var1);
    }
}

