/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.query;

import java.util.Objects;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.criteria.context.Context;
import org.seasar.doma.jdbc.criteria.context.Criterion;
import org.seasar.doma.jdbc.criteria.context.DeleteContext;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.BuilderSupport;
import org.seasar.doma.jdbc.dialect.Dialect;

public class DeleteBuilder {
    private final Config config;
    private final DeleteContext context;
    private final Function<String, String> commenter;
    private final PreparedSqlBuilder buf;
    private final BuilderSupport support;

    public DeleteBuilder(Config config, DeleteContext context, Function<String, String> commenter, SqlLogType sqlLogType) {
        this(config, context, commenter, new PreparedSqlBuilder(config, SqlKind.DELETE, sqlLogType), DeleteBuilder.createAliasManager(config, context));
    }

    public DeleteBuilder(Config config, DeleteContext context, Function<String, String> commenter, PreparedSqlBuilder buf, AliasManager aliasManager) {
        Objects.requireNonNull(config);
        this.config = Objects.requireNonNull(config);
        this.context = Objects.requireNonNull(context);
        this.commenter = Objects.requireNonNull(commenter);
        this.buf = Objects.requireNonNull(buf);
        Objects.requireNonNull(aliasManager);
        this.support = new BuilderSupport(config, commenter, buf, aliasManager);
    }

    private static AliasManager createAliasManager(Config config, Context context) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(context);
        Dialect dialect = config.getDialect();
        if (dialect.supportsAliasInDeleteClause() || dialect.supportsAliasInDeleteStatement()) {
            return AliasManager.create(config, context);
        }
        return AliasManager.createEmpty(config, context);
    }

    public PreparedSql build() {
        this.buf.appendSql("delete");
        if (this.config.getDialect().supportsAliasInDeleteClause()) {
            this.buf.appendSql(" ");
            this.alias(this.context.entityMetamodel);
        }
        this.buf.appendSql(" from ");
        this.tableOnly(this.context.entityMetamodel);
        if (this.config.getDialect().supportsAliasInDeleteStatement()) {
            this.buf.appendSql(" ");
            this.alias(this.context.entityMetamodel);
        }
        if (!this.context.where.isEmpty()) {
            this.buf.appendSql(" where ");
            int index = 0;
            for (Criterion criterion : this.context.where) {
                this.visitCriterion(index++, criterion);
                this.buf.appendSql(" and ");
            }
            this.buf.cutBackSql(5);
        }
        return this.buf.build(this.commenter);
    }

    private void alias(EntityMetamodel<?> entityMetamodel) {
        this.support.alias(entityMetamodel);
    }

    private void tableOnly(EntityMetamodel<?> entityMetamodel) {
        this.support.tableOnly(entityMetamodel);
    }

    private void visitCriterion(int index, Criterion criterion) {
        this.support.visitCriterion(index, criterion);
    }
}

