/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.query;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.criteria.context.Context;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.query.AliasManager;

class EmptyAliasManager
extends AliasManager {
    private final Config config;

    EmptyAliasManager(Config config, Context context) {
        this(config, context, __ -> "");
    }

    private EmptyAliasManager(Config config, Context context, Function<EntityMetamodel<?>, String> aliasResolver) {
        super(context);
        this.config = Objects.requireNonNull(config);
        EmptyAliasManager.replaceAliases(context.getEntityMetamodels(), this.entityAliasMap, this.propertyAliasMap, aliasResolver);
    }

    private static void replaceAliases(List<EntityMetamodel<?>> entityMetamodels, Map<EntityMetamodel<?>, String> entityAliasMap, Map<PropertyMetamodel<?>, String> propertyAliasMap, Function<EntityMetamodel<?>, String> aliasResolver) {
        entityAliasMap.clear();
        propertyAliasMap.clear();
        for (EntityMetamodel<?> entityMetamodel : entityMetamodels) {
            String alias = aliasResolver.apply(entityMetamodel);
            entityAliasMap.put(entityMetamodel, alias);
            for (PropertyMetamodel<?> propertyMetamodel : entityMetamodel.allPropertyMetamodels()) {
                propertyAliasMap.put(propertyMetamodel, alias);
            }
        }
    }

    @Override
    protected AliasManager asParent() {
        Function<EntityMetamodel<?>, String> aliasResolver = m -> EmptyAliasManager.getQualifiedTableName(this.config, m);
        return new EmptyAliasManager(this.config, this.context, aliasResolver);
    }

    private static String getQualifiedTableName(Config config, EntityMetamodel<?> entityMetamodel) {
        return entityMetamodel.asType().getQualifiedTableName(config.getNaming()::apply, config.getDialect()::applyQuote);
    }
}

