/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.query;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.criteria.context.Criterion;
import org.seasar.doma.jdbc.criteria.context.Join;
import org.seasar.doma.jdbc.criteria.context.JoinKind;
import org.seasar.doma.jdbc.criteria.context.OrderByItem;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.context.SetOperationContext;
import org.seasar.doma.jdbc.criteria.expression.AggregateFunction;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.DistinctOption;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.BuilderSupport;
import org.seasar.doma.jdbc.criteria.query.CriteriaBuilder;

public class SelectBuilder {
    private final SelectContext context;
    private final Function<String, String> commenter;
    private final PreparedSqlBuilder buf;
    private final AliasManager aliasManager;
    private final BuilderSupport support;
    private final CriteriaBuilder criteriaBuilder;

    public SelectBuilder(Config config, SelectContext context, Function<String, String> commenter, SqlLogType sqlLogType) {
        this(config, context, commenter, new PreparedSqlBuilder(config, SqlKind.SELECT, sqlLogType), AliasManager.create(config, context));
    }

    public SelectBuilder(Config config, SelectContext context, Function<String, String> commenter, PreparedSqlBuilder buf, AliasManager aliasManager) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(config);
        this.context = Objects.requireNonNull(context);
        this.commenter = Objects.requireNonNull(commenter);
        this.buf = Objects.requireNonNull(buf);
        this.aliasManager = Objects.requireNonNull(aliasManager);
        this.support = new BuilderSupport(config, commenter, buf, aliasManager);
        this.criteriaBuilder = config.getDialect().getCriteriaBuilder();
    }

    public PreparedSql build() {
        this.interpret();
        return this.buf.build(this.commenter);
    }

    void interpret() {
        this.with();
        this.select();
        this.from();
        this.join();
        this.where();
        this.groupBy();
        this.having();
        this.orderBy();
        this.offsetAndFetch();
        this.forUpdate();
    }

    private void with() {
        this.support.with(this.context.withContexts);
    }

    private void select() {
        List<PropertyMetamodel<?>> propertyMetamodels;
        this.buf.appendSql("select ");
        if (this.context.distinct == DistinctOption.Kind.BASIC) {
            this.buf.appendSql("distinct ");
        }
        if ((propertyMetamodels = this.context.getProjectionPropertyMetamodels()).isEmpty()) {
            this.buf.appendSql("*");
        } else {
            for (PropertyMetamodel<?> propertyMetamodel : propertyMetamodels) {
                this.selectColumn(propertyMetamodel);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
    }

    private void from() {
        this.buf.appendSql(" from ");
        SetOperationContext setOperationContext = this.context.setOperationContextForSubQuery.orElse(null);
        if (setOperationContext != null) {
            this.subQuery(this.context.entityMetamodel, setOperationContext, this.aliasManager);
        } else {
            this.table(this.context.entityMetamodel);
        }
        if (this.context.forUpdate != null) {
            ForUpdateOption option = this.context.forUpdate.option;
            this.criteriaBuilder.lockWithTableHint(this.buf, option, this::column);
        }
    }

    private void join() {
        if (!this.context.joins.isEmpty()) {
            for (Join join : this.context.joins) {
                if (join.kind == JoinKind.INNER) {
                    this.buf.appendSql(" inner join ");
                } else if (join.kind == JoinKind.LEFT) {
                    this.buf.appendSql(" left outer join ");
                }
                this.table(join.entityMetamodel);
                if (join.on.isEmpty()) continue;
                this.buf.appendSql(" on (");
                int index = 0;
                for (Criterion criterion : join.on) {
                    this.visitCriterion(index, criterion);
                    ++index;
                    this.buf.appendSql(" and ");
                }
                this.buf.cutBackSql(5);
                this.buf.appendSql(")");
            }
        }
    }

    private void where() {
        if (!this.context.where.isEmpty()) {
            this.buf.appendSql(" where ");
            int index = 0;
            for (Criterion criterion : this.context.where) {
                this.visitCriterion(index++, criterion);
                this.buf.appendSql(" and ");
            }
            this.buf.cutBackSql(5);
        }
    }

    private void groupBy() {
        List<PropertyMetamodel<?>> propertyMetamodels;
        if (this.context.groupBy.isEmpty() && (propertyMetamodels = this.context.getProjectionPropertyMetamodels()).stream().anyMatch(p -> p instanceof AggregateFunction)) {
            List groupKeys = propertyMetamodels.stream().filter(p -> !(p instanceof AggregateFunction)).collect(Collectors.toList());
            this.context.groupBy.addAll(groupKeys);
        }
        if (!this.context.groupBy.isEmpty()) {
            this.buf.appendSql(" group by ");
            for (PropertyMetamodel<?> p2 : this.context.groupBy) {
                this.column(p2);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
    }

    private void having() {
        if (!this.context.having.isEmpty()) {
            this.buf.appendSql(" having ");
            int index = 0;
            for (Criterion criterion : this.context.having) {
                this.visitCriterion(index++, criterion);
                this.buf.appendSql(" and ");
            }
            this.buf.cutBackSql(5);
        }
    }

    private void orderBy() {
        if (!this.context.orderBy.isEmpty()) {
            this.buf.appendSql(" order by ");
            for (Pair<OrderByItem, String> pair : this.context.orderBy) {
                ((OrderByItem)pair.fst).accept(new OrderByItem.Visitor(){

                    @Override
                    public void visit(OrderByItem.Name name) {
                        SelectBuilder.this.column(name.value);
                    }

                    @Override
                    public void visit(OrderByItem.Index index) {
                        SelectBuilder.this.buf.appendSql(String.valueOf(index.value));
                    }
                });
                this.buf.appendSql(" " + (String)pair.snd + ", ");
            }
            this.buf.cutBackSql(2);
        }
    }

    private void offsetAndFetch() {
        if (this.context.offset == null && this.context.limit == null) {
            return;
        }
        int offset = this.context.offset == null || this.context.offset < 0 ? 0 : this.context.offset;
        int limit = this.context.limit == null || this.context.limit < 0 ? 0 : this.context.limit;
        this.criteriaBuilder.offsetAndFetch(this.buf, offset, limit);
    }

    private void forUpdate() {
        if (this.context.forUpdate != null) {
            ForUpdateOption option = this.context.forUpdate.option;
            this.criteriaBuilder.forUpdate(this.buf, option, this::column, this.aliasManager);
        }
    }

    private void table(EntityMetamodel<?> entityMetamodel) {
        this.support.table(entityMetamodel);
    }

    private void subQuery(EntityMetamodel<?> entityMetamodel, SetOperationContext<?> setOperationContext, AliasManager aliasManager) {
        this.support.subQuery(entityMetamodel, setOperationContext, aliasManager);
    }

    private void column(PropertyMetamodel<?> propertyMetamodel) {
        this.support.column(propertyMetamodel);
    }

    private void selectColumn(PropertyMetamodel<?> propertyMetamodel) {
        this.support.selectColumn(propertyMetamodel);
    }

    private void visitCriterion(int index, Criterion criterion) {
        this.support.visitCriterion(index, criterion);
    }
}

