/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.query;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.Pair;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.criteria.context.OrderByItem;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.context.SetOperationContext;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.SelectBuilder;
import org.seasar.doma.jdbc.dialect.Dialect;

public class SetOperationBuilder {
    private final Config config;
    private final SetOperationContext<?> context;
    private final Function<String, String> commenter;
    private final PreparedSqlBuilder buf;
    private final Optional<AliasManager> parentAliasManager;

    public SetOperationBuilder(Config config, SetOperationContext<?> context, Function<String, String> commenter, SqlLogType sqlLogType) {
        this.config = Objects.requireNonNull(config);
        this.context = Objects.requireNonNull(context);
        this.commenter = Objects.requireNonNull(commenter);
        this.parentAliasManager = Optional.empty();
        Objects.requireNonNull(sqlLogType);
        this.buf = new PreparedSqlBuilder(config, SqlKind.SELECT, sqlLogType);
    }

    public SetOperationBuilder(Config config, SetOperationContext<?> context, Function<String, String> commenter, PreparedSqlBuilder buf, AliasManager parentAliasManager) {
        this.config = Objects.requireNonNull(config);
        this.context = Objects.requireNonNull(context);
        this.commenter = Objects.requireNonNull(commenter);
        this.parentAliasManager = Optional.of(parentAliasManager);
        this.buf = Objects.requireNonNull(buf);
    }

    public PreparedSql build() {
        this.context.accept(new SetOperationContext.Visitor<Void>(){

            @Override
            public Void visit(SetOperationContext.Select<?> select) {
                SelectContext context = select.context;
                AliasManager am = SetOperationBuilder.this.parentAliasManager.map(it -> AliasManager.createChild(SetOperationBuilder.this.config, context, it)).orElseGet(() -> AliasManager.create(SetOperationBuilder.this.config, context));
                SelectBuilder builder = new SelectBuilder(SetOperationBuilder.this.config, context, SetOperationBuilder.this.commenter, SetOperationBuilder.this.buf, am);
                builder.interpret();
                return null;
            }

            @Override
            public Void visit(SetOperationContext.Union<?> union) {
                this.union("union", union.left, union.right, union.orderBy);
                return null;
            }

            @Override
            public Void visit(SetOperationContext.UnionAll<?> unionAll) {
                this.union("union all", unionAll.left, unionAll.right, unionAll.orderBy);
                return null;
            }

            private void union(String op, SetOperationContext<?> left, SetOperationContext<?> right, List<Pair<OrderByItem.Index, String>> orderBy) {
                String close;
                String open;
                Dialect dialect = SetOperationBuilder.this.config.getDialect();
                if (orderBy.isEmpty() || !dialect.supportsParenthesesForSetOperands()) {
                    open = "";
                    close = "";
                } else {
                    open = "(";
                    close = ")";
                }
                SetOperationBuilder.this.buf.appendSql(open);
                left.accept(this);
                SetOperationBuilder.this.buf.appendSql(close + " " + op + " " + open);
                right.accept(this);
                SetOperationBuilder.this.buf.appendSql(close);
                this.orderBy(orderBy);
            }

            private void orderBy(List<Pair<OrderByItem.Index, String>> orderBy) {
                if (!orderBy.isEmpty()) {
                    SetOperationBuilder.this.buf.appendSql(" order by ");
                    for (Pair<OrderByItem.Index, String> pair : orderBy) {
                        OrderByItem.Index index = (OrderByItem.Index)pair.fst;
                        SetOperationBuilder.this.buf.appendSql(String.valueOf(index.value));
                        SetOperationBuilder.this.buf.appendSql(" " + (String)pair.snd + ", ");
                    }
                    SetOperationBuilder.this.buf.cutBackSql(2);
                }
            }
        });
        return this.buf.build(this.commenter);
    }
}

