/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.query;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.criteria.context.Context;
import org.seasar.doma.jdbc.criteria.context.Criterion;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.context.UpdateContext;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.BuilderSupport;
import org.seasar.doma.jdbc.dialect.Dialect;

public class UpdateBuilder {
    private final Config config;
    private final UpdateContext context;
    private final Function<String, String> commenter;
    private final PreparedSqlBuilder buf;
    private final BuilderSupport support;

    public UpdateBuilder(Config config, UpdateContext context, Function<String, String> commenter, SqlLogType sqlLogType) {
        this(config, context, commenter, new PreparedSqlBuilder(config, SqlKind.UPDATE, sqlLogType), UpdateBuilder.createAliasManager(config, context));
    }

    private static AliasManager createAliasManager(Config config, Context context) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(context);
        Dialect dialect = config.getDialect();
        if (dialect.supportsAliasInUpdateClause() || dialect.supportsAliasInUpdateStatement()) {
            return AliasManager.create(config, context);
        }
        return AliasManager.createEmpty(config, context);
    }

    public UpdateBuilder(Config config, UpdateContext context, Function<String, String> commenter, PreparedSqlBuilder buf, AliasManager aliasManager) {
        this.config = Objects.requireNonNull(config);
        this.context = Objects.requireNonNull(context);
        this.commenter = Objects.requireNonNull(commenter);
        this.buf = Objects.requireNonNull(buf);
        Objects.requireNonNull(aliasManager);
        this.support = new BuilderSupport(config, commenter, buf, aliasManager);
    }

    public PreparedSql build() {
        this.buf.appendSql("update ");
        if (this.config.getDialect().supportsAliasInUpdateClause()) {
            this.alias(this.context.entityMetamodel);
        } else {
            this.tableOnly(this.context.entityMetamodel);
            if (this.config.getDialect().supportsAliasInUpdateStatement()) {
                this.buf.appendSql(" ");
                this.alias(this.context.entityMetamodel);
            }
        }
        if (!this.context.set.isEmpty()) {
            this.buf.appendSql(" set ");
            Set<Map.Entry<Operand.Prop, Operand>> entries = this.context.set.entrySet();
            entries.forEach(entry -> {
                this.column((Operand.Prop)entry.getKey());
                this.buf.appendSql(" = ");
                this.operand((Operand)entry.getValue());
                this.buf.appendSql(", ");
            });
            this.buf.cutBackSql(2);
        }
        if (this.config.getDialect().supportsAliasInUpdateClause()) {
            this.buf.appendSql(" from ");
            this.tableOnly(this.context.entityMetamodel);
            this.buf.appendSql(" ");
            this.alias(this.context.entityMetamodel);
        }
        if (!this.context.where.isEmpty()) {
            this.buf.appendSql(" where ");
            int index = 0;
            for (Criterion criterion : this.context.where) {
                this.visitCriterion(index++, criterion);
                this.buf.appendSql(" and ");
            }
            this.buf.cutBackSql(5);
        }
        return this.buf.build(this.commenter);
    }

    private void tableOnly(EntityMetamodel<?> entityMetamodel) {
        this.support.tableOnly(entityMetamodel);
    }

    private void alias(EntityMetamodel<?> entityMetamodel) {
        this.support.alias(entityMetamodel);
    }

    private void operand(Operand operand) {
        this.support.operand(operand);
    }

    private void column(Operand.Prop prop) {
        this.support.columnWithoutAlias(prop);
    }

    private void visitCriterion(int index, Criterion criterion) {
        this.support.visitCriterion(index, criterion);
    }
}

