/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.BatchResult;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlBatchInsertStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlBatchInsertTerminate;
import org.seasar.doma.jdbc.criteria.statement.Statement;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public class EntityqlBatchInsertIntermediate<ENTITY>
extends AbstractStatement<EntityqlBatchInsertIntermediate<ENTITY>, BatchResult<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final List<ENTITY> entities;
    private final InsertSettings settings;
    private final DuplicateKeyType duplicateKeyType;
    private final List<PropertyMetamodel<?>> keys = new ArrayList();

    public EntityqlBatchInsertIntermediate(Config config, EntityMetamodel<ENTITY> entityMetamodel, List<ENTITY> entities, InsertSettings settings, DuplicateKeyType duplicateKeyType) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entities = Objects.requireNonNull(entities);
        this.settings = Objects.requireNonNull(settings);
        this.duplicateKeyType = Objects.requireNonNull(duplicateKeyType);
    }

    public Statement<BatchResult<ENTITY>> keys(PropertyMetamodel<?> ... keys) {
        Objects.requireNonNull(keys);
        this.keys.addAll(Arrays.stream(keys).toList());
        return this;
    }

    @Override
    public BatchResult<ENTITY> execute() {
        return (BatchResult)super.execute();
    }

    @Override
    protected Command<BatchResult<ENTITY>> createCommand() {
        EntityqlBatchInsertTerminate<ENTITY> terminate = new EntityqlBatchInsertTerminate<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType, this.keys);
        return terminate.createCommand();
    }

    @Override
    public Sql<?> asSql() {
        if (this.entities.isEmpty()) {
            return EntityqlBatchInsertStatement.EMPTY_SQL;
        }
        return super.asSql();
    }
}

