/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.DeleteReturningCommand;
import org.seasar.doma.jdbc.criteria.context.DeleteSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.Singular;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoDeleteQuery;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class EntityqlDeleteReturningStatement<ENTITY>
extends AbstractStatement<EntityqlDeleteReturningStatement<ENTITY>, ENTITY>
implements Singular<ENTITY> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final DeleteSettings settings;
    private final ReturningProperties returning;

    public EntityqlDeleteReturningStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, DeleteSettings settings, ReturningProperties returning) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
        this.returning = Objects.requireNonNull(returning);
    }

    @Override
    public ENTITY execute() {
        return (ENTITY)super.execute();
    }

    @Override
    protected Command<ENTITY> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoDeleteQuery<ENTITY> query = this.config.getQueryImplementors().createAutoDeleteQuery(EXECUTE_METHOD, entityType);
        query.setConfig(this.config);
        query.setMethod(EXECUTE_METHOD);
        query.setEntity(this.entity);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setVersionIgnored(this.settings.getIgnoreVersion());
        query.setOptimisticLockExceptionSuppressed(this.settings.getSuppressOptimisticLockException());
        query.setMessage(this.settings.getComment());
        query.setReturning(this.returning);
        query.prepare();
        final DeleteReturningCommand<Object> command = this.config.getCommandImplementors().createDeleteReturningCommand(EXECUTE_METHOD, query, new EntitySingleResultHandler<ENTITY>(entityType), () -> null);
        return new Command<ENTITY>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public ENTITY execute() {
                Object entity = command.execute();
                query.complete();
                return entity;
            }
        };
    }
}

