/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.DeleteCommand;
import org.seasar.doma.jdbc.criteria.context.DeleteSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlDeleteReturningStatement;
import org.seasar.doma.jdbc.criteria.statement.ReturningPropertyMetamodels;
import org.seasar.doma.jdbc.criteria.statement.Singular;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoDeleteQuery;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class EntityqlDeleteStatement<ENTITY>
extends AbstractStatement<EntityqlDeleteStatement<ENTITY>, Result<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final DeleteSettings settings;

    public EntityqlDeleteStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, DeleteSettings settings) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
    }

    public Singular<ENTITY> returning(PropertyMetamodel<?> ... properties) {
        ReturningProperties returning = ReturningPropertyMetamodels.of(this.entityMetamodel, properties);
        return new EntityqlDeleteReturningStatement<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, returning);
    }

    @Override
    public Result<ENTITY> execute() {
        return (Result)super.execute();
    }

    @Override
    protected Command<Result<ENTITY>> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoDeleteQuery<ENTITY> query = this.config.getQueryImplementors().createAutoDeleteQuery(EXECUTE_METHOD, entityType);
        query.setConfig(this.config);
        query.setMethod(EXECUTE_METHOD);
        query.setEntity(this.entity);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setVersionIgnored(this.settings.getIgnoreVersion());
        query.setOptimisticLockExceptionSuppressed(this.settings.getSuppressOptimisticLockException());
        query.setMessage(this.settings.getComment());
        query.prepare();
        final DeleteCommand command = this.config.getCommandImplementors().createDeleteCommand(EXECUTE_METHOD, query);
        return new Command<Result<ENTITY>>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public Result<ENTITY> execute() {
                int count = command.execute();
                query.complete();
                return new Result(count, query.getEntity());
            }
        };
    }
}

