/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlInsertTerminal;
import org.seasar.doma.jdbc.criteria.statement.Singular;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public class EntityqlInsertIntermediate<ENTITY>
extends AbstractStatement<EntityqlInsertIntermediate<ENTITY>, Result<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final InsertSettings settings;
    private final DuplicateKeyType duplicateKeyType;

    public EntityqlInsertIntermediate(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, InsertSettings settings, DuplicateKeyType duplicateKeyType) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
        this.duplicateKeyType = Objects.requireNonNull(duplicateKeyType);
    }

    public EntityqlInsertTerminal<ENTITY> keys(PropertyMetamodel<?> ... keys) {
        Objects.requireNonNull(keys);
        return new EntityqlInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType, Arrays.stream(keys).toList());
    }

    public Singular<ENTITY> returning(PropertyMetamodel<?> ... properties) {
        return new EntityqlInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType, List.of()).returning(properties);
    }

    @Override
    public Result<ENTITY> execute() {
        return (Result)super.execute();
    }

    @Override
    protected Command<Result<ENTITY>> createCommand() {
        EntityqlInsertTerminal<ENTITY> terminal = new EntityqlInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType, List.of());
        return terminal.createCommand();
    }
}

