/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.InsertReturningCommand;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.Singular;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoInsertQuery;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.ReturningProperties;

class EntityqlInsertReturningStatement<ENTITY>
extends AbstractStatement<EntityqlInsertReturningStatement<ENTITY>, ENTITY>
implements Singular<ENTITY> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final InsertSettings settings;
    private final DuplicateKeyType duplicateKeyType;
    private final List<PropertyMetamodel<?>> keys;
    private final ReturningProperties returning;

    public EntityqlInsertReturningStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, InsertSettings settings, DuplicateKeyType duplicateKeyType, List<PropertyMetamodel<?>> keys, ReturningProperties returning) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
        this.duplicateKeyType = Objects.requireNonNull(duplicateKeyType);
        this.keys = Objects.requireNonNull(keys);
        this.returning = Objects.requireNonNull(returning);
    }

    @Override
    public ENTITY execute() {
        return (ENTITY)super.execute();
    }

    @Override
    protected Command<ENTITY> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoInsertQuery<ENTITY> query = this.config.getQueryImplementors().createAutoInsertQuery(EXECUTE_METHOD, entityType);
        query.setMethod(EXECUTE_METHOD);
        query.setConfig(this.config);
        query.setEntity(this.entity);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setNullExcluded(this.settings.getExcludeNull());
        query.setIncludedPropertyNames((String[])this.settings.include().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setExcludedPropertyNames((String[])this.settings.exclude().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setMessage(this.settings.getComment());
        query.setDuplicateKeyType(this.duplicateKeyType);
        query.setDuplicateKeyNames((String[])this.keys.stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setReturning(this.returning);
        query.prepare();
        final InsertReturningCommand<Object> command = this.config.getCommandImplementors().createInsertReturningCommand(EXECUTE_METHOD, query, new EntitySingleResultHandler<ENTITY>(entityType), () -> null);
        return new Command<ENTITY>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public ENTITY execute() {
                Object entity = command.execute();
                query.complete();
                return entity;
            }
        };
    }
}

