/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Collections;
import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlInsertIntermediate;
import org.seasar.doma.jdbc.criteria.statement.EntityqlInsertTerminal;
import org.seasar.doma.jdbc.criteria.statement.Singular;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public class EntityqlInsertStatement<ENTITY>
extends AbstractStatement<EntityqlInsertStatement<ENTITY>, Result<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final InsertSettings settings;
    private DuplicateKeyType duplicateKeyType = DuplicateKeyType.EXCEPTION;

    public EntityqlInsertStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, InsertSettings settings) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
    }

    public EntityqlInsertIntermediate<ENTITY> onDuplicateKeyUpdate() {
        this.duplicateKeyType = DuplicateKeyType.UPDATE;
        return new EntityqlInsertIntermediate<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType);
    }

    public EntityqlInsertIntermediate<ENTITY> onDuplicateKeyIgnore() {
        this.duplicateKeyType = DuplicateKeyType.IGNORE;
        return new EntityqlInsertIntermediate<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType);
    }

    public Singular<ENTITY> returning(PropertyMetamodel<?> ... properties) {
        return new EntityqlInsertIntermediate<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType).returning(properties);
    }

    @Override
    public Result<ENTITY> execute() {
        return (Result)super.execute();
    }

    @Override
    protected Command<Result<ENTITY>> createCommand() {
        EntityqlInsertTerminal<ENTITY> terminal = new EntityqlInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType, Collections.emptyList());
        return terminal.createCommand();
    }
}

