/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlInsertReturningStatement;
import org.seasar.doma.jdbc.criteria.statement.ReturningPropertyMetamodels;
import org.seasar.doma.jdbc.criteria.statement.Singular;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoInsertQuery;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class EntityqlInsertTerminal<ENTITY>
extends AbstractStatement<EntityqlInsertTerminal<ENTITY>, Result<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final InsertSettings settings;
    private final DuplicateKeyType duplicateKeyType;
    private final List<PropertyMetamodel<?>> keys;

    public EntityqlInsertTerminal(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, InsertSettings settings, DuplicateKeyType duplicateKeyType, List<PropertyMetamodel<?>> keys) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
        this.duplicateKeyType = Objects.requireNonNull(duplicateKeyType);
        this.keys = Objects.requireNonNull(keys);
    }

    public Singular<ENTITY> returning(PropertyMetamodel<?> ... properties) {
        ReturningProperties returning = ReturningPropertyMetamodels.of(this.entityMetamodel, properties);
        return new EntityqlInsertReturningStatement<ENTITY>(this.config, this.entityMetamodel, this.entity, this.settings, this.duplicateKeyType, this.keys, returning);
    }

    @Override
    public Result<ENTITY> execute() {
        return (Result)super.execute();
    }

    @Override
    protected Command<Result<ENTITY>> createCommand() {
        final AutoInsertQuery<ENTITY> query = this.createQuery();
        final InsertCommand command = this.config.getCommandImplementors().createInsertCommand(EXECUTE_METHOD, query);
        return new Command<Result<ENTITY>>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public Result<ENTITY> execute() {
                Integer count = command.execute();
                query.complete();
                return new Result(count, query.getEntity());
            }
        };
    }

    protected AutoInsertQuery<ENTITY> createQuery() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        AutoInsertQuery<ENTITY> query = this.config.getQueryImplementors().createAutoInsertQuery(EXECUTE_METHOD, entityType);
        query.setMethod(EXECUTE_METHOD);
        query.setConfig(this.config);
        query.setEntity(this.entity);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setNullExcluded(this.settings.getExcludeNull());
        query.setIncludedPropertyNames((String[])this.settings.include().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setExcludedPropertyNames((String[])this.settings.exclude().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setMessage(this.settings.getComment());
        query.setDuplicateKeyType(this.duplicateKeyType);
        query.setDuplicateKeyNames((String[])this.keys.stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.prepare();
        return query;
    }
}

