/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.MultiResult;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlMultiInsertStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlMultiInsertTerminal;
import org.seasar.doma.jdbc.criteria.statement.Listable;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public class EntityqlMultiInsertIntermediate<ENTITY>
extends AbstractStatement<EntityqlMultiInsertIntermediate<ENTITY>, MultiResult<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final List<ENTITY> entities;
    private final InsertSettings settings;
    private final DuplicateKeyType duplicateKeyType;

    public EntityqlMultiInsertIntermediate(Config config, EntityMetamodel<ENTITY> entityMetamodel, List<ENTITY> entities, InsertSettings settings, DuplicateKeyType duplicateKeyType) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entities = Objects.requireNonNull(entities);
        this.settings = Objects.requireNonNull(settings);
        this.duplicateKeyType = Objects.requireNonNull(duplicateKeyType);
    }

    public EntityqlMultiInsertTerminal<ENTITY> keys(PropertyMetamodel<?> ... keys) {
        Objects.requireNonNull(keys);
        return new EntityqlMultiInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType, Arrays.stream(keys).toList());
    }

    public Listable<ENTITY> returning(PropertyMetamodel<?> ... properties) {
        return new EntityqlMultiInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType, List.of()).returning(properties);
    }

    @Override
    public MultiResult<ENTITY> execute() {
        return (MultiResult)super.execute();
    }

    @Override
    protected Command<MultiResult<ENTITY>> createCommand() {
        EntityqlMultiInsertTerminal<ENTITY> terminal = new EntityqlMultiInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType, List.of());
        return terminal.createCommand();
    }

    @Override
    public Sql<?> asSql() {
        if (this.entities.isEmpty()) {
            return EntityqlMultiInsertStatement.EMPTY_SQL;
        }
        return super.asSql();
    }
}

