/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.MultiResult;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EmptySql;
import org.seasar.doma.jdbc.criteria.statement.EntityqlMultiInsertIntermediate;
import org.seasar.doma.jdbc.criteria.statement.EntityqlMultiInsertTerminal;
import org.seasar.doma.jdbc.criteria.statement.Listable;
import org.seasar.doma.jdbc.query.DuplicateKeyType;

public class EntityqlMultiInsertStatement<ENTITY>
extends AbstractStatement<EntityqlMultiInsertStatement<ENTITY>, MultiResult<ENTITY>> {
    static final EmptySql EMPTY_SQL = new EmptySql(SqlKind.MULTI_INSERT);
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final List<ENTITY> entities;
    private final InsertSettings settings;
    private DuplicateKeyType duplicateKeyType = DuplicateKeyType.EXCEPTION;

    public EntityqlMultiInsertStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, List<ENTITY> entities, InsertSettings settings) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entities = Objects.requireNonNull(entities);
        this.settings = Objects.requireNonNull(settings);
    }

    public EntityqlMultiInsertIntermediate<ENTITY> onDuplicateKeyUpdate() {
        this.duplicateKeyType = DuplicateKeyType.UPDATE;
        return new EntityqlMultiInsertIntermediate<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType);
    }

    public EntityqlMultiInsertIntermediate<ENTITY> onDuplicateKeyIgnore() {
        this.duplicateKeyType = DuplicateKeyType.IGNORE;
        return new EntityqlMultiInsertIntermediate<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType);
    }

    public Listable<ENTITY> returning(PropertyMetamodel<?> ... properties) {
        return new EntityqlMultiInsertIntermediate<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType).returning(properties);
    }

    @Override
    public MultiResult<ENTITY> execute() {
        return (MultiResult)super.execute();
    }

    @Override
    protected Command<MultiResult<ENTITY>> createCommand() {
        EntityqlMultiInsertTerminal<ENTITY> terminal = new EntityqlMultiInsertTerminal<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType, Collections.emptyList());
        return terminal.createCommand();
    }

    @Override
    public Sql<?> asSql() {
        if (this.entities.isEmpty()) {
            return EMPTY_SQL;
        }
        return super.asSql();
    }
}

