/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.MultiResult;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlMultiInsertReturningStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlMultiInsertStatement;
import org.seasar.doma.jdbc.criteria.statement.Listable;
import org.seasar.doma.jdbc.criteria.statement.ReturningPropertyMetamodels;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoMultiInsertQuery;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class EntityqlMultiInsertTerminal<ENTITY>
extends AbstractStatement<EntityqlMultiInsertTerminal<ENTITY>, MultiResult<ENTITY>> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final List<ENTITY> entities;
    private final InsertSettings settings;
    private final DuplicateKeyType duplicateKeyType;
    private final List<PropertyMetamodel<?>> keys;

    public EntityqlMultiInsertTerminal(Config config, EntityMetamodel<ENTITY> entityMetamodel, List<ENTITY> entities, InsertSettings settings, DuplicateKeyType duplicateKeyType, List<PropertyMetamodel<?>> keys) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entities = Objects.requireNonNull(entities);
        this.settings = Objects.requireNonNull(settings);
        this.duplicateKeyType = Objects.requireNonNull(duplicateKeyType);
        this.keys = Objects.requireNonNull(keys);
    }

    public Listable<ENTITY> returning(PropertyMetamodel<?> ... properties) {
        ReturningProperties returning = ReturningPropertyMetamodels.of(this.entityMetamodel, properties);
        return new EntityqlMultiInsertReturningStatement<ENTITY>(this.config, this.entityMetamodel, this.entities, this.settings, this.duplicateKeyType, this.keys, returning);
    }

    @Override
    public MultiResult<ENTITY> execute() {
        return (MultiResult)super.execute();
    }

    @Override
    protected Command<MultiResult<ENTITY>> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoMultiInsertQuery<ENTITY> query = this.config.getQueryImplementors().createAutoMultiInsertQuery(EXECUTE_METHOD, entityType);
        query.setMethod(EXECUTE_METHOD);
        query.setConfig(this.config);
        query.setEntities(this.entities);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setIncludedPropertyNames((String[])this.settings.include().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setExcludedPropertyNames((String[])this.settings.exclude().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setMessage(this.settings.getComment());
        query.setDuplicateKeyType(this.duplicateKeyType);
        query.setDuplicateKeyNames((String[])this.keys.stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.prepare();
        final InsertCommand command = this.config.getCommandImplementors().createInsertCommand(EXECUTE_METHOD, query);
        return new Command<MultiResult<ENTITY>>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public MultiResult<ENTITY> execute() {
                Integer count = command.execute();
                query.complete();
                return new MultiResult(count, query.getEntities());
            }
        };
    }

    @Override
    public Sql<?> asSql() {
        if (this.entities.isEmpty()) {
            return EntityqlMultiInsertStatement.EMPTY_SQL;
        }
        return super.asSql();
    }
}

