/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.UpdateReturningCommand;
import org.seasar.doma.jdbc.criteria.context.UpdateSettings;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.Singular;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.AutoUpdateQuery;
import org.seasar.doma.jdbc.query.Query;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class EntityqlUpdateReturningStatement<ENTITY>
extends AbstractStatement<EntityqlUpdateReturningStatement<ENTITY>, ENTITY>
implements Singular<ENTITY> {
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final ENTITY entity;
    private final UpdateSettings settings;
    private final ReturningProperties returning;

    public EntityqlUpdateReturningStatement(Config config, EntityMetamodel<ENTITY> entityMetamodel, ENTITY entity, UpdateSettings settings, ReturningProperties returning) {
        super(Objects.requireNonNull(config));
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.entity = Objects.requireNonNull(entity);
        this.settings = Objects.requireNonNull(settings);
        this.returning = Objects.requireNonNull(returning);
    }

    @Override
    public ENTITY execute() {
        return (ENTITY)super.execute();
    }

    @Override
    protected Command<ENTITY> createCommand() {
        EntityType<ENTITY> entityType = this.entityMetamodel.asType();
        final AutoUpdateQuery<ENTITY> query = this.config.getQueryImplementors().createAutoUpdateQuery(EXECUTE_METHOD, entityType);
        query.setConfig(this.config);
        query.setEntity(this.entity);
        query.setMethod(EXECUTE_METHOD);
        query.setCallerClassName(this.getClass().getName());
        query.setCallerMethodName("execute");
        query.setQueryTimeout(this.settings.getQueryTimeout());
        query.setSqlLogType(this.settings.getSqlLogType());
        query.setNullExcluded(this.settings.getExcludeNull());
        query.setVersionIgnored(this.settings.getIgnoreVersion());
        query.setIncludedPropertyNames((String[])this.settings.include().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setExcludedPropertyNames((String[])this.settings.exclude().stream().map(PropertyMetamodel::getName).toArray(String[]::new));
        query.setUnchangedPropertyIncluded(false);
        query.setOptimisticLockExceptionSuppressed(this.settings.getSuppressOptimisticLockException());
        query.setMessage(this.settings.getComment());
        query.setReturning(this.returning);
        query.prepare();
        final UpdateReturningCommand<Object> command = this.config.getCommandImplementors().createUpdateReturningCommand(EXECUTE_METHOD, query, new EntitySingleResultHandler<ENTITY>(entityType), () -> null);
        return new Command<ENTITY>(){

            @Override
            public Query getQuery() {
                return query;
            }

            @Override
            public ENTITY execute() {
                Object entity = command.execute();
                query.complete();
                return entity;
            }
        };
    }
}

