/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.seasar.doma.DomaException;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

class ReturningPropertyMetamodels
implements ReturningProperties {
    private final EntityMetamodel<?> entityMetamodel;
    private final List<? extends EntityPropertyType<?, ?>> propertyTypes;

    private ReturningPropertyMetamodels(EntityMetamodel<?> entityMetamodel, List<? extends EntityPropertyType<?, ?>> propertyTypes) {
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.propertyTypes = Objects.requireNonNull(propertyTypes);
    }

    @Override
    public List<? extends EntityPropertyType<?, ?>> resolve(EntityType<?> entityType) {
        Objects.requireNonNull(entityType);
        if (!this.entityMetamodel.asType().equals(entityType)) {
            throw new DomaException((MessageResource)Message.DOMA6013, this.entityMetamodel.asType().getEntityClass().getName(), entityType.getEntityClass().getName());
        }
        return this.propertyTypes;
    }

    static ReturningProperties of(EntityMetamodel<?> entityMetamodel, PropertyMetamodel<?> ... propertyMetamodels) {
        Objects.requireNonNull(entityMetamodel);
        if (propertyMetamodels.length == 0) {
            return ReturningProperties.ALL;
        }
        HashSet allProperties = new HashSet(entityMetamodel.allPropertyMetamodels());
        for (int i = 0; i < propertyMetamodels.length; ++i) {
            PropertyMetamodel<?> p = propertyMetamodels[i];
            if (allProperties.contains(p)) continue;
            throw new DomaException((MessageResource)Message.DOMA6012, p.getName(), i, entityMetamodel.asType().getEntityClass().getName());
        }
        return new ReturningPropertyMetamodels(entityMetamodel, Arrays.stream(propertyMetamodels).map(PropertyMetamodel::asType).toList());
    }
}

