/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.BatchResult;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.criteria.context.DeleteContext;
import org.seasar.doma.jdbc.criteria.context.DeleteSettings;
import org.seasar.doma.jdbc.criteria.declaration.DeleteDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.WhereDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.EntityqlBatchDeleteStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlDeleteStatement;
import org.seasar.doma.jdbc.criteria.statement.NativeSqlDeleteStarting;
import org.seasar.doma.jdbc.criteria.statement.Statement;

public class UnifiedDeleteStarting<ENTITY> {
    private final Config config;
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final DeleteSettings settings;

    public UnifiedDeleteStarting(Config config, EntityMetamodel<ENTITY> entityMetamodel, DeleteSettings settings) {
        this.config = Objects.requireNonNull(config);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.settings = Objects.requireNonNull(settings);
    }

    public EntityqlDeleteStatement<ENTITY> single(ENTITY entity) {
        Objects.requireNonNull(entity);
        return this.asEntityqlDeleteStatement(entity);
    }

    public Statement<BatchResult<ENTITY>> batch(List<ENTITY> entities) {
        Objects.requireNonNull(entities);
        return this.asEntityqlBatchDeleteStatement(entities);
    }

    public Statement<Integer> where(Consumer<WhereDeclaration> block) {
        Objects.requireNonNull(block);
        return this.asNativeSqlDeleteStarting().where(block);
    }

    public Statement<Integer> all() {
        this.settings.setAllowEmptyWhere(true);
        return this.asNativeSqlDeleteStarting();
    }

    private EntityqlDeleteStatement<ENTITY> asEntityqlDeleteStatement(ENTITY entity) {
        return new EntityqlDeleteStatement<ENTITY>(this.config, this.entityMetamodel, entity, this.settings);
    }

    private Statement<BatchResult<ENTITY>> asEntityqlBatchDeleteStatement(List<ENTITY> entities) {
        return new EntityqlBatchDeleteStatement<ENTITY>(this.config, this.entityMetamodel, entities, this.settings);
    }

    private NativeSqlDeleteStarting asNativeSqlDeleteStarting() {
        DeleteContext context = new DeleteContext(this.entityMetamodel, this.settings);
        DeleteDeclaration declaration = new DeleteDeclaration(context);
        return new NativeSqlDeleteStarting(this.config, declaration);
    }
}

