/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.criteria.context.InsertContext;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.context.SubSelectContext;
import org.seasar.doma.jdbc.criteria.declaration.InsertDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.InsertSelectDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.ValuesDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.EntityqlBatchInsertStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlInsertStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlMultiInsertStatement;
import org.seasar.doma.jdbc.criteria.statement.NativeSqlInsertStarting;
import org.seasar.doma.jdbc.criteria.statement.NativeSqlInsertTerminal;

public class UnifiedInsertStarting<ENTITY> {
    private final Config config;
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final InsertSettings settings;

    public UnifiedInsertStarting(Config config, EntityMetamodel<ENTITY> entityMetamodel, InsertSettings settings) {
        this.config = Objects.requireNonNull(config);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.settings = Objects.requireNonNull(settings);
    }

    public EntityqlInsertStatement<ENTITY> single(ENTITY entity) {
        Objects.requireNonNull(entity);
        return this.asEntityqlInsertStatement(entity);
    }

    public EntityqlBatchInsertStatement<ENTITY> batch(List<ENTITY> entities) {
        Objects.requireNonNull(entities);
        return this.asEntityqlBatchInsertStatement(entities);
    }

    public EntityqlMultiInsertStatement<ENTITY> multi(List<ENTITY> entities) {
        Objects.requireNonNull(entities);
        return this.asEntityqlMultiInsertStatement(entities);
    }

    public NativeSqlInsertTerminal values(Consumer<ValuesDeclaration> block) {
        Objects.requireNonNull(block);
        return this.asNativeSqlInsertStarting().values(block);
    }

    public NativeSqlInsertTerminal select(Function<InsertSelectDeclaration, SubSelectContext<?>> block) {
        Objects.requireNonNull(block);
        return this.asNativeSqlInsertStarting().select(block);
    }

    private EntityqlInsertStatement<ENTITY> asEntityqlInsertStatement(ENTITY entity) {
        return new EntityqlInsertStatement<ENTITY>(this.config, this.entityMetamodel, entity, this.settings);
    }

    private EntityqlBatchInsertStatement<ENTITY> asEntityqlBatchInsertStatement(List<ENTITY> entities) {
        return new EntityqlBatchInsertStatement<ENTITY>(this.config, this.entityMetamodel, entities, this.settings);
    }

    private EntityqlMultiInsertStatement<ENTITY> asEntityqlMultiInsertStatement(List<ENTITY> entities) {
        return new EntityqlMultiInsertStatement<ENTITY>(this.config, this.entityMetamodel, entities, this.settings);
    }

    private NativeSqlInsertStarting asNativeSqlInsertStarting() {
        InsertContext context = new InsertContext(this.entityMetamodel, this.settings);
        InsertDeclaration declaration = new InsertDeclaration(context);
        return new NativeSqlInsertStarting(this.config, declaration);
    }
}

