/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.declaration.JoinDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.OrderByNameDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.SelectFromDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.WhereDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.AssociationOption;
import org.seasar.doma.jdbc.criteria.option.DistinctOption;
import org.seasar.doma.jdbc.criteria.option.ForUpdateOption;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityQueryable;
import org.seasar.doma.jdbc.criteria.statement.EntityqlSelectStarting;
import org.seasar.doma.jdbc.criteria.statement.Listable;

public class UnifiedSelectTerminal<ENTITY>
extends AbstractStatement<UnifiedSelectTerminal<ENTITY>, List<ENTITY>>
implements EntityQueryable<ENTITY> {
    private final SelectFromDeclaration declaration;
    private final EntityMetamodel<ENTITY> entityMetamodel;

    UnifiedSelectTerminal(Config config, SelectFromDeclaration declaration, EntityMetamodel<ENTITY> entityMetamodel) {
        super(Objects.requireNonNull(config));
        this.declaration = Objects.requireNonNull(declaration);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
    }

    @Override
    public EntityQueryable<ENTITY> distinct() {
        this.declaration.distinct(DistinctOption.basic());
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> distinct(DistinctOption distinctOption) {
        Objects.requireNonNull(distinctOption);
        this.declaration.distinct(distinctOption);
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> innerJoin(EntityMetamodel<?> entityMetamodel, Consumer<JoinDeclaration> block) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(block);
        this.declaration.innerJoin(entityMetamodel, block);
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> leftJoin(EntityMetamodel<?> entityMetamodel, Consumer<JoinDeclaration> block) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(block);
        this.declaration.leftJoin(entityMetamodel, block);
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> where(Consumer<WhereDeclaration> block) {
        Objects.requireNonNull(block);
        this.declaration.where(block);
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> orderBy(Consumer<OrderByNameDeclaration> block) {
        Objects.requireNonNull(block);
        this.declaration.orderBy(block);
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> limit(Integer limit) {
        this.declaration.limit(limit);
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> offset(Integer offset) {
        this.declaration.offset(offset);
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> forUpdate() {
        this.declaration.forUpdate(ForUpdateOption.basic(new PropertyMetamodel[0]));
        return this;
    }

    @Override
    public EntityQueryable<ENTITY> forUpdate(ForUpdateOption option) {
        Objects.requireNonNull(option);
        this.declaration.forUpdate(option);
        return this;
    }

    @Override
    public <ENTITY1, ENTITY2> EntityQueryable<ENTITY> associate(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiConsumer<ENTITY1, ENTITY2> associator) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        this.declaration.associate(first, second, associator, AssociationOption.mandatory());
        return this;
    }

    @Override
    public <ENTITY1, ENTITY2> EntityQueryable<ENTITY> associate(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiConsumer<ENTITY1, ENTITY2> associator, AssociationOption option) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        Objects.requireNonNull(option);
        this.declaration.associate(first, second, associator, option);
        return this;
    }

    @Override
    public <ENTITY1, ENTITY2> EntityQueryable<ENTITY> associateWith(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiFunction<ENTITY1, ENTITY2, ENTITY1> associator) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        this.declaration.associateWith(first, second, associator, AssociationOption.mandatory());
        return this;
    }

    @Override
    public <ENTITY1, ENTITY2> EntityQueryable<ENTITY> associateWith(EntityMetamodel<ENTITY1> first, EntityMetamodel<ENTITY2> second, BiFunction<ENTITY1, ENTITY2, ENTITY1> associator, AssociationOption option) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(associator);
        Objects.requireNonNull(option);
        this.declaration.associateWith(first, second, associator, option);
        return this;
    }

    @Override
    public <RESULT> Listable<RESULT> project(EntityMetamodel<RESULT> entityMetamodel) {
        Objects.requireNonNull(entityMetamodel);
        return this.asEntityqlSelectStarting().select(entityMetamodel);
    }

    @Override
    public <RESULT> Listable<RESULT> projectTo(EntityMetamodel<RESULT> entityMetamodel, PropertyMetamodel<?> ... propertyMetamodels) {
        Objects.requireNonNull(entityMetamodel);
        Objects.requireNonNull(propertyMetamodels);
        return this.asEntityqlSelectStarting().selectTo(entityMetamodel, propertyMetamodels);
    }

    @Override
    protected Command<List<ENTITY>> createCommand() {
        return this.asEntityqlSelectStarting().createCommand();
    }

    private EntityqlSelectStarting<ENTITY> asEntityqlSelectStarting() {
        return new EntityqlSelectStarting<ENTITY>(this.config, this.declaration, this.entityMetamodel);
    }
}

