/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.seasar.doma.jdbc.BatchResult;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.criteria.context.UpdateContext;
import org.seasar.doma.jdbc.criteria.context.UpdateSettings;
import org.seasar.doma.jdbc.criteria.declaration.SetDeclaration;
import org.seasar.doma.jdbc.criteria.declaration.UpdateDeclaration;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.statement.EntityqlBatchUpdateStatement;
import org.seasar.doma.jdbc.criteria.statement.EntityqlUpdateStatement;
import org.seasar.doma.jdbc.criteria.statement.NativeSqlUpdateStarting;
import org.seasar.doma.jdbc.criteria.statement.NativeSqlUpdateTerminal;
import org.seasar.doma.jdbc.criteria.statement.Statement;

public class UnifiedUpdateStarting<ENTITY> {
    private final Config config;
    private final EntityMetamodel<ENTITY> entityMetamodel;
    private final UpdateSettings settings;

    public UnifiedUpdateStarting(Config config, EntityMetamodel<ENTITY> entityMetamodel, UpdateSettings settings) {
        this.config = Objects.requireNonNull(config);
        this.entityMetamodel = Objects.requireNonNull(entityMetamodel);
        this.settings = Objects.requireNonNull(settings);
    }

    public EntityqlUpdateStatement<ENTITY> single(ENTITY entity) {
        Objects.requireNonNull(entity);
        return this.asEntityqlUpdateStatement(entity);
    }

    public Statement<BatchResult<ENTITY>> batch(List<ENTITY> entities) {
        Objects.requireNonNull(entities);
        return this.asEntityqlBatchUpdateStatement(entities);
    }

    public NativeSqlUpdateTerminal set(Consumer<SetDeclaration> block) {
        Objects.requireNonNull(block);
        return this.asNativeSqlUpdateStarting().set(block);
    }

    private EntityqlUpdateStatement<ENTITY> asEntityqlUpdateStatement(ENTITY entity) {
        return new EntityqlUpdateStatement<ENTITY>(this.config, this.entityMetamodel, entity, this.settings);
    }

    private EntityqlBatchUpdateStatement<ENTITY> asEntityqlBatchUpdateStatement(List<ENTITY> entities) {
        return new EntityqlBatchUpdateStatement<ENTITY>(this.config, this.entityMetamodel, entities, this.settings);
    }

    private NativeSqlUpdateStarting asNativeSqlUpdateStarting() {
        UpdateContext context = new UpdateContext(this.entityMetamodel, this.settings);
        UpdateDeclaration declaration = new UpdateDeclaration(context);
        return new NativeSqlUpdateStarting(this.config, declaration);
    }
}

