/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.InsertAssembler;
import org.seasar.doma.jdbc.query.InsertAssemblerContext;

public class DefaultInsertAssembler<ENTITY>
implements InsertAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<ENTITY> entityType;
    private final Naming naming;
    private final Dialect dialect;
    private final List<EntityPropertyType<ENTITY, ?>> insertPropertyTypes;
    private final ENTITY entity;

    public DefaultInsertAssembler(InsertAssemblerContext<ENTITY> context) {
        Objects.requireNonNull(context);
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.naming = context.naming;
        this.dialect = context.dialect;
        this.insertPropertyTypes = context.insertPropertyTypes;
        this.entity = context.entity;
    }

    @Override
    public void assemble() {
        this.assembleInsertInto();
        this.buf.appendSql(" ");
        this.assembleValues();
    }

    void assembleInsertInto() {
        this.buf.appendSql("insert into ");
        this.buf.appendSql(this.entityType.getQualifiedTableName(this.naming::apply, this.dialect::applyQuote));
        this.buf.appendSql(" (");
        if (!this.insertPropertyTypes.isEmpty()) {
            for (EntityPropertyType<ENTITY, ?> propertyType : this.insertPropertyTypes) {
                this.buf.appendSql(propertyType.getColumnName(this.naming::apply, this.dialect::applyQuote));
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
        this.buf.appendSql(")");
    }

    void assembleValues() {
        this.buf.appendSql("values (");
        if (!this.insertPropertyTypes.isEmpty()) {
            for (EntityPropertyType<ENTITY, ?> propertyType : this.insertPropertyTypes) {
                Property<ENTITY, ?> property = propertyType.createProperty();
                property.load(this.entity);
                this.buf.appendParameter(property.asInParameter());
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
        this.buf.appendSql(")");
    }
}

