/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.List;
import java.util.Objects;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.jdbc.query.UpdateAssembler;
import org.seasar.doma.jdbc.query.UpdateAssemblerContext;
import org.seasar.doma.jdbc.query.UpdateQueryHelper;

public class DefaultUpdateAssembler<ENTITY>
implements UpdateAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<ENTITY> entityType;
    private final Naming naming;
    private final Dialect dialect;
    private final UpdateQueryHelper<ENTITY> updateQueryHelper;
    private final List<EntityPropertyType<ENTITY, ?>> idPropertyTypes;
    private final List<EntityPropertyType<ENTITY, ?>> updatePropertyTypes;
    private final VersionPropertyType<ENTITY, ?, ?> versionPropertyType;
    private final EntityPropertyType<ENTITY, ?> tenantIdPropertyType;
    private final boolean versionIgnored;
    private final ENTITY entity;
    private final ReturningProperties returning;

    public DefaultUpdateAssembler(UpdateAssemblerContext<ENTITY> context) {
        Objects.requireNonNull(context);
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.naming = context.naming;
        this.dialect = context.dialect;
        this.updateQueryHelper = context.updateQueryHelper;
        this.idPropertyTypes = context.idPropertyTypes;
        this.updatePropertyTypes = context.updatePropertyTypes;
        this.versionPropertyType = context.versionPropertyType;
        this.tenantIdPropertyType = context.tenantIdPropertyType;
        this.versionIgnored = context.versionIgnored;
        this.entity = context.entity;
        this.returning = context.returning;
    }

    @Override
    public void assemble() {
        this.assembleUpdateSet();
        this.buf.appendSql(" ");
        this.assembleWhere();
    }

    void assembleUpdateSet() {
        this.buf.appendSql("update ");
        this.buf.appendSql(this.entityType.getQualifiedTableName(this.naming::apply, this.dialect::applyQuote));
        this.buf.appendSql(" set ");
        this.updateQueryHelper.populateValues(this.entity, this.updatePropertyTypes, this.versionPropertyType, this.buf);
    }

    void assembleWhere() {
        Property<ENTITY, Object> property;
        boolean whereClauseAppended = false;
        if (this.idPropertyTypes.size() > 0) {
            this.buf.appendSql("where ");
            whereClauseAppended = true;
            for (EntityPropertyType<ENTITY, ?> propertyType : this.idPropertyTypes) {
                Property<ENTITY, ?> property2 = propertyType.createProperty();
                property2.load(this.entity);
                this.buf.appendSql(propertyType.getColumnName(this.naming::apply, this.dialect::applyQuote));
                this.buf.appendSql(" = ");
                this.buf.appendParameter(property2.asInParameter());
                this.buf.appendSql(" and ");
            }
            this.buf.cutBackSql(5);
        }
        if (!this.versionIgnored && this.versionPropertyType != null) {
            if (whereClauseAppended) {
                this.buf.appendSql(" and ");
            } else {
                this.buf.appendSql("where ");
                whereClauseAppended = true;
            }
            property = this.versionPropertyType.createProperty();
            property.load(this.entity);
            this.buf.appendSql(this.versionPropertyType.getColumnName(this.naming::apply, this.dialect::applyQuote));
            this.buf.appendSql(" = ");
            this.buf.appendParameter(property.asInParameter());
        }
        if (this.tenantIdPropertyType != null) {
            if (whereClauseAppended) {
                this.buf.appendSql(" and ");
            } else {
                this.buf.appendSql("where ");
                whereClauseAppended = true;
            }
            property = this.tenantIdPropertyType.createProperty();
            property.load(this.entity);
            this.buf.appendSql(this.tenantIdPropertyType.getColumnName(this.naming::apply, this.dialect::applyQuote));
            this.buf.appendSql(" = ");
            this.buf.appendParameter(property.asInParameter());
        }
    }
}

