/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.criteria.query.CriteriaBuilder;
import org.seasar.doma.jdbc.dialect.DefaultDeleteAssembler;
import org.seasar.doma.jdbc.dialect.DefaultInsertAssembler;
import org.seasar.doma.jdbc.dialect.DefaultUpdateAssembler;
import org.seasar.doma.jdbc.id.AutoGeneratedKeysType;
import org.seasar.doma.jdbc.query.DeleteAssembler;
import org.seasar.doma.jdbc.query.DeleteAssemblerContext;
import org.seasar.doma.jdbc.query.InsertAssembler;
import org.seasar.doma.jdbc.query.InsertAssemblerContext;
import org.seasar.doma.jdbc.query.MultiInsertAssembler;
import org.seasar.doma.jdbc.query.MultiInsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpdateAssembler;
import org.seasar.doma.jdbc.query.UpdateAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.type.JdbcType;

public interface Dialect {
    public String getName();

    public SqlNode transformSelectSqlNode(SqlNode var1, SelectOptions var2);

    public SqlNode transformSelectSqlNodeForGettingCount(SqlNode var1);

    public boolean isUniqueConstraintViolated(SQLException var1);

    public boolean includesIdentityColumn();

    default public boolean includesIdentityColumn(Object idValue) {
        return this.includesIdentityColumn();
    }

    public boolean supportsIdentity();

    public boolean supportsSequence();

    public boolean supportsAutoGeneratedKeys();

    public boolean supportsBatchUpdateResults();

    default public boolean supportsBatchExecutionReturningGeneratedValues() {
        return false;
    }

    public boolean supportsSelectForUpdate(SelectForUpdateType var1, boolean var2);

    public boolean supportsResultSetReturningAsOutParameter();

    @Deprecated
    public boolean supportsIdentityReservation();

    default public boolean supportsAliasInDeleteClause() {
        return false;
    }

    default public boolean supportsAliasInDeleteStatement() {
        return true;
    }

    default public boolean supportsAliasInUpdateClause() {
        return false;
    }

    default public boolean supportsAliasInUpdateStatement() {
        return true;
    }

    default public boolean supportsModOperator() {
        return true;
    }

    default public boolean supportsMultiRowInsertStatement() {
        return true;
    }

    default public boolean supportsAutoIncrementWhenInsertingMultipleRows() {
        return true;
    }

    default public boolean supportsUpsertEmulationWithMergeStatement() {
        return false;
    }

    default public boolean supportsParenthesesForSetOperands() {
        return true;
    }

    public Sql<?> getIdentitySelectSql(String var1, String var2, String var3, String var4, boolean var5, boolean var6);

    @Deprecated
    public Sql<?> getIdentityReservationSql(String var1, String var2, String var3, String var4, boolean var5, boolean var6, int var7);

    public Sql<?> getSequenceNextValSql(String var1, long var2);

    public JdbcType<ResultSet> getResultSetType();

    public String applyQuote(String var1);

    public String removeQuote(String var1);

    public Throwable getRootCause(SQLException var1);

    public JdbcMappingVisitor getJdbcMappingVisitor();

    public SqlLogFormattingVisitor getSqlLogFormattingVisitor();

    public ExpressionFunctions getExpressionFunctions();

    public ScriptBlockContext createScriptBlockContext();

    public String getScriptBlockDelimiter();

    public AutoGeneratedKeysType getAutoGeneratedKeysType();

    public CriteriaBuilder getCriteriaBuilder();

    public UpsertAssembler getUpsertAssembler(UpsertAssemblerContext var1);

    public <ENTITY> MultiInsertAssembler getMultiInsertAssembler(MultiInsertAssemblerContext<ENTITY> var1);

    default public <ENTITY> InsertAssembler getInsertAssembler(InsertAssemblerContext<ENTITY> context) {
        return new DefaultInsertAssembler<ENTITY>(context);
    }

    default public <ENTITY> UpdateAssembler getUpdateAssembler(UpdateAssemblerContext<ENTITY> context) {
        return new DefaultUpdateAssembler<ENTITY>(context);
    }

    default public <ENTITY> DeleteAssembler getDeleteAssembler(DeleteAssemblerContext<ENTITY> context) {
        return new DefaultDeleteAssembler<ENTITY>(context);
    }

    default public boolean supportsReturning() {
        return true;
    }
}

