/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.ReturningProperties;

final class H2AssemblerUtil {
    H2AssemblerUtil() {
    }

    static void assembleFinalTable(PreparedSqlBuilder buf, EntityType<?> entityType, Naming naming, Dialect dialect, ReturningProperties returning, Runnable block) {
        H2AssemblerUtil.assembleTable(buf, entityType, naming, dialect, returning, block, "final");
    }

    static void assembleOldTable(PreparedSqlBuilder buf, EntityType<?> entityType, Naming naming, Dialect dialect, ReturningProperties returning, Runnable block) {
        H2AssemblerUtil.assembleTable(buf, entityType, naming, dialect, returning, block, "old");
    }

    static void assembleTable(PreparedSqlBuilder buf, EntityType<?> entityType, Naming naming, Dialect dialect, ReturningProperties returning, Runnable block, String tableType) {
        buf.appendSql("select ");
        for (EntityPropertyType<?, ?> p : returning.resolve(entityType)) {
            buf.appendSql(p.getColumnName(naming::apply, dialect::applyQuote));
            buf.appendSql(", ");
        }
        buf.cutBackSql(2);
        buf.appendSql(" from ");
        buf.appendSql(tableType);
        buf.appendSql(" table (");
        block.run();
        buf.appendSql(")");
    }
}

