/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.dialect.H214199Dialect;
import org.seasar.doma.jdbc.dialect.H2DeleteAssembler;
import org.seasar.doma.jdbc.dialect.H2InsertAssembler;
import org.seasar.doma.jdbc.dialect.H2MultiInsertAssembler;
import org.seasar.doma.jdbc.dialect.H2UpdateAssembler;
import org.seasar.doma.jdbc.dialect.H2UpsertAssembler;
import org.seasar.doma.jdbc.query.DeleteAssembler;
import org.seasar.doma.jdbc.query.DeleteAssemblerContext;
import org.seasar.doma.jdbc.query.InsertAssembler;
import org.seasar.doma.jdbc.query.InsertAssemblerContext;
import org.seasar.doma.jdbc.query.MultiInsertAssembler;
import org.seasar.doma.jdbc.query.MultiInsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpdateAssembler;
import org.seasar.doma.jdbc.query.UpdateAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;

public class H2Dialect
extends H214199Dialect {
    public H2Dialect() {
        this(new H2JdbcMappingVisitor(), new H2SqlLogFormattingVisitor(), new H2ExpressionFunctions());
    }

    public H2Dialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new H2SqlLogFormattingVisitor(), new H2ExpressionFunctions());
    }

    public H2Dialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new H2JdbcMappingVisitor(), sqlLogFormattingVisitor, new H2ExpressionFunctions());
    }

    public H2Dialect(ExpressionFunctions expressionFunctions) {
        this(new H2JdbcMappingVisitor(), new H2SqlLogFormattingVisitor(), expressionFunctions);
    }

    public H2Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new H2ExpressionFunctions());
    }

    public H2Dialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public boolean includesIdentityColumn() {
        return false;
    }

    @Override
    public boolean supportsUpsertEmulationWithMergeStatement() {
        return true;
    }

    @Override
    public boolean supportsBatchExecutionReturningGeneratedValues() {
        return true;
    }

    @Override
    public UpsertAssembler getUpsertAssembler(UpsertAssemblerContext context) {
        return new H2UpsertAssembler(context);
    }

    @Override
    public <ENTITY> InsertAssembler getInsertAssembler(InsertAssemblerContext<ENTITY> context) {
        return new H2InsertAssembler<ENTITY>(context);
    }

    @Override
    public <ENTITY> MultiInsertAssembler getMultiInsertAssembler(MultiInsertAssemblerContext<ENTITY> context) {
        return new H2MultiInsertAssembler<ENTITY>(context);
    }

    @Override
    public <ENTITY> UpdateAssembler getUpdateAssembler(UpdateAssemblerContext<ENTITY> context) {
        return new H2UpdateAssembler<ENTITY>(context);
    }

    @Override
    public <ENTITY> DeleteAssembler getDeleteAssembler(DeleteAssemblerContext<ENTITY> context) {
        return new H2DeleteAssembler<ENTITY>(context);
    }

    public static class H2JdbcMappingVisitor
    extends H214199Dialect.H214199JdbcMappingVisitor {
    }

    public static class H2SqlLogFormattingVisitor
    extends H214199Dialect.H214199SqlLogFormattingVisitor {
    }

    public static class H2ExpressionFunctions
    extends H214199Dialect.H214199ExpressionFunctions {
        public H2ExpressionFunctions() {
        }

        public H2ExpressionFunctions(char[] wildcards) {
            super(wildcards);
        }

        protected H2ExpressionFunctions(char escapeChar, char[] wildcards) {
            super(escapeChar, wildcards);
        }
    }
}

