/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.Objects;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.DefaultMultiInsertAssembler;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.H2AssemblerUtil;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.MultiInsertAssembler;
import org.seasar.doma.jdbc.query.MultiInsertAssemblerContext;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class H2MultiInsertAssembler<ENTITY>
implements MultiInsertAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final Naming naming;
    private final Dialect dialect;
    private final ReturningProperties returning;
    private final DefaultMultiInsertAssembler<ENTITY> multiInsertAssembler;

    public H2MultiInsertAssembler(MultiInsertAssemblerContext<ENTITY> context) {
        Objects.requireNonNull(context);
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.naming = context.naming;
        this.dialect = context.dialect;
        this.returning = context.returning;
        this.multiInsertAssembler = new DefaultMultiInsertAssembler<ENTITY>(context);
    }

    @Override
    public void assemble() {
        if (this.returning.isNone()) {
            this.multiInsertAssembler.assemble();
        } else {
            H2AssemblerUtil.assembleFinalTable(this.buf, this.entityType, this.naming, this.dialect, this.returning, this.multiInsertAssembler::assemble);
        }
    }
}

