/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.Objects;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.DefaultUpdateAssembler;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.H2AssemblerUtil;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.jdbc.query.UpdateAssembler;
import org.seasar.doma.jdbc.query.UpdateAssemblerContext;

public class H2UpdateAssembler<ENTITY>
implements UpdateAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final Naming naming;
    private final Dialect dialect;
    private final ReturningProperties returning;
    private final DefaultUpdateAssembler<ENTITY> updateAssembler;

    public H2UpdateAssembler(UpdateAssemblerContext<ENTITY> context) {
        Objects.requireNonNull(context);
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.naming = context.naming;
        this.dialect = context.dialect;
        this.returning = context.returning;
        this.updateAssembler = new DefaultUpdateAssembler<ENTITY>(context);
    }

    @Override
    public void assemble() {
        if (this.returning.isNone()) {
            this.updateAssembler.assemble();
        } else {
            H2AssemblerUtil.assembleFinalTable(this.buf, this.entityType, this.naming, this.dialect, this.returning, this.updateAssembler::assemble);
        }
    }
}

