/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.List;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.H2AssemblerUtil;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.DuplicateKeyType;
import org.seasar.doma.jdbc.query.InsertRow;
import org.seasar.doma.jdbc.query.QueryOperand;
import org.seasar.doma.jdbc.query.QueryOperandPair;
import org.seasar.doma.jdbc.query.ReturningProperties;
import org.seasar.doma.jdbc.query.UpsertAssembler;
import org.seasar.doma.jdbc.query.UpsertAssemblerContext;
import org.seasar.doma.jdbc.query.UpsertAssemblerSupport;

public class H2UpsertAssembler
implements UpsertAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final DuplicateKeyType duplicateKeyType;
    private final UpsertAssemblerSupport upsertAssemblerSupport;
    private final List<? extends EntityPropertyType<?, ?>> keys;
    private final List<? extends EntityPropertyType<?, ?>> insertPropertyTypes;
    private final List<InsertRow> insertRows;
    private final List<QueryOperandPair> setValues;
    private final Naming naming;
    private final Dialect dialect;
    private final ReturningProperties returning;
    private final QueryOperand.Visitor queryOperandVisitor = new QueryOperandVisitor();

    public H2UpsertAssembler(UpsertAssemblerContext context) {
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.duplicateKeyType = context.duplicateKeyType;
        this.keys = context.keys;
        this.insertPropertyTypes = context.insertPropertyTypes;
        this.insertRows = context.insertRows;
        this.setValues = context.setValues;
        this.naming = context.naming;
        this.dialect = context.dialect;
        this.returning = context.returning;
        this.upsertAssemblerSupport = new UpsertAssemblerSupport(context.naming, context.dialect);
    }

    @Override
    public void assemble() {
        if (this.returning.isNone()) {
            this.assembleMergeInto();
        } else {
            H2AssemblerUtil.assembleFinalTable(this.buf, this.entityType, this.naming, this.dialect, this.returning, this::assembleMergeInto);
        }
    }

    private void assembleMergeInto() {
        this.buf.appendSql("merge into ");
        this.tableNameAndAlias(this.entityType);
        this.buf.appendSql(" using (");
        this.excludeQuery();
        this.buf.appendSql(") as ");
        this.excludeAlias();
        this.buf.appendSql(" on ");
        for (EntityPropertyType<?, ?> key : this.keys) {
            this.targetColumn(key);
            this.buf.appendSql(" = ");
            this.excludeColumn(key);
            this.buf.appendSql(" and ");
        }
        this.buf.cutBackSql(5);
        this.buf.appendSql(" when not matched then insert (");
        for (EntityPropertyType<?, ?> p : this.insertPropertyTypes) {
            this.column(p);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(") values (");
        for (EntityPropertyType<?, ?> p : this.insertPropertyTypes) {
            this.excludeColumn(p);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(")");
        if (this.duplicateKeyType == DuplicateKeyType.UPDATE) {
            this.buf.appendSql(" when matched then update set ");
            for (QueryOperandPair pair : this.setValues) {
                this.targetColumn(pair.getLeft().getEntityPropertyType());
                this.buf.appendSql(" = ");
                pair.getRight().accept(this.queryOperandVisitor);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
        }
    }

    private void excludeQuery() {
        this.buf.appendSql("select ");
        for (EntityPropertyType<?, ?> entityPropertyType : this.insertPropertyTypes) {
            this.column(entityPropertyType);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(" from values ");
        for (InsertRow insertRow : this.insertRows) {
            this.buf.appendSql("(");
            for (QueryOperand value : insertRow) {
                value.accept(this.queryOperandVisitor);
                this.buf.appendSql(", ");
            }
            this.buf.cutBackSql(2);
            this.buf.appendSql("), ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(" as x (");
        for (EntityPropertyType entityPropertyType : this.insertPropertyTypes) {
            this.column(entityPropertyType);
            this.buf.appendSql(", ");
        }
        this.buf.cutBackSql(2);
        this.buf.appendSql(")");
    }

    private void tableNameAndAlias(EntityType<?> entityType) {
        String sql = this.upsertAssemblerSupport.targetTable(entityType, UpsertAssemblerSupport.TableNameType.NAME_AS_ALIAS);
        this.buf.appendSql(sql);
    }

    private void excludeAlias() {
        String sql = this.upsertAssemblerSupport.excludeAlias();
        this.buf.appendSql(sql);
    }

    private void targetColumn(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.targetProp(propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
        this.buf.appendSql(sql);
    }

    private void excludeColumn(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.excludeProp(propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
        this.buf.appendSql(sql);
    }

    private void column(EntityPropertyType<?, ?> propertyType) {
        String sql = this.upsertAssemblerSupport.excludeProp(propertyType, UpsertAssemblerSupport.ColumnNameType.NAME);
        this.buf.appendSql(sql);
    }

    class QueryOperandVisitor
    implements QueryOperand.Visitor {
        QueryOperandVisitor() {
        }

        @Override
        public void visit(QueryOperand.Param param) {
            H2UpsertAssembler.this.buf.appendParameter(param.inParameter);
        }

        @Override
        public void visit(QueryOperand.Prop prop) {
            String sql = H2UpsertAssembler.this.upsertAssemblerSupport.excludeProp(prop.propertyType, UpsertAssemblerSupport.ColumnNameType.NAME_ALIAS);
            H2UpsertAssembler.this.buf.appendSql(sql);
        }
    }
}

