/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.ReturningProperties;

final class MssqlAssemblerUtil {
    MssqlAssemblerUtil() {
    }

    static void assembleInsertedOutput(PreparedSqlBuilder buf, EntityType<?> entityType, Naming naming, Dialect dialect, ReturningProperties returning) {
        MssqlAssemblerUtil.assembleOutput(buf, entityType, naming, dialect, returning, "inserted");
    }

    static void assembleDeletedOutput(PreparedSqlBuilder buf, EntityType<?> entityType, Naming naming, Dialect dialect, ReturningProperties returning) {
        MssqlAssemblerUtil.assembleOutput(buf, entityType, naming, dialect, returning, "deleted");
    }

    private static void assembleOutput(PreparedSqlBuilder buf, EntityType<?> entityType, Naming naming, Dialect dialect, ReturningProperties returning, String tableType) {
        buf.appendSql("output ");
        for (EntityPropertyType<?, ?> p : returning.resolve(entityType)) {
            buf.appendSql(tableType);
            buf.appendSql(".");
            buf.appendSql(p.getColumnName(naming::apply, dialect::applyQuote));
            buf.appendSql(", ");
        }
        buf.cutBackSql(2);
        buf.appendSql(" ");
    }
}

