/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.util.Objects;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.DefaultDeleteAssembler;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.MssqlAssemblerUtil;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.query.DeleteAssembler;
import org.seasar.doma.jdbc.query.DeleteAssemblerContext;
import org.seasar.doma.jdbc.query.ReturningProperties;

public class MssqlDeleteAssembler<ENTITY>
implements DeleteAssembler {
    private final PreparedSqlBuilder buf;
    private final EntityType<?> entityType;
    private final Naming naming;
    private final Dialect dialect;
    private final ReturningProperties returning;
    private final DefaultDeleteAssembler<ENTITY> deleteAssembler;

    public MssqlDeleteAssembler(DeleteAssemblerContext<ENTITY> context) {
        Objects.requireNonNull(context);
        this.buf = context.buf;
        this.entityType = context.entityType;
        this.naming = context.naming;
        this.dialect = context.dialect;
        this.returning = context.returning;
        this.deleteAssembler = new DefaultDeleteAssembler<ENTITY>(context);
    }

    @Override
    public void assemble() {
        this.deleteAssembler.assembleDeleteFrom();
        this.buf.appendSql(" ");
        this.assembleOutput();
        this.deleteAssembler.assembleWhere();
    }

    private void assembleOutput() {
        if (!this.returning.isNone()) {
            MssqlAssemblerUtil.assembleDeletedOutput(this.buf, this.entityType, this.naming, this.dialect, this.returning);
        }
    }
}

